/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class ViewDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public ViewEntity findByName(String viewName) {
        return (ViewEntity)((EntityManager)this.entityManagerProvider.get()).find(ViewEntity.class, (Object)viewName);
    }

    @RequiresSession
    public List<ViewEntity> findByCommonName(String viewCommonName) {
        ArrayList list = Lists.newArrayList();
        if (viewCommonName != null) {
            for (ViewEntity viewEntity : this.findAll()) {
                if (!viewCommonName.equals(viewEntity.getCommonName())) continue;
                list.add(viewEntity);
            }
        }
        return list;
    }

    @RequiresSession
    public List<ViewEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allViews", ViewEntity.class);
        return query.getResultList();
    }

    @Transactional
    public void refresh(ViewEntity ViewEntity2) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)ViewEntity2);
    }

    @Transactional
    public void create(ViewEntity ViewEntity2) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)ViewEntity2);
    }

    @Transactional
    public ViewEntity merge(ViewEntity ViewEntity2) {
        return (ViewEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)ViewEntity2);
    }

    @Transactional
    public void remove(ViewEntity ViewEntity2) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(ViewEntity2));
    }
}

