/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class UserDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public UserEntity findByPK(Integer userPK) {
        return (UserEntity)((EntityManager)this.entityManagerProvider.get()).find(UserEntity.class, (Object)userPK);
    }

    @RequiresSession
    public List<UserEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT user_entity FROM UserEntity user_entity", UserEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public UserEntity findUserByName(String userName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("userByName", UserEntity.class);
        query.setParameter("username", (Object)userName.toLowerCase());
        try {
            return (UserEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @RequiresSession
    public List<UserEntity> findUsersByPrincipal(List<PrincipalEntity> principalList) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT user_entity FROM UserEntity user_entity WHERE user_entity.principal IN :principalList", UserEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(principalList, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            query.setParameter("principalList", (Object)chunk);
            result.addAll(this.daoUtils.selectList(query, new Object[0]));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public UserEntity findUserByPrincipal(PrincipalEntity principal) {
        if (principal == null) {
            return null;
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT user_entity FROM UserEntity user_entity WHERE user_entity.principal.id=:principalId", UserEntity.class);
        query.setParameter("principalId", (Object)principal.getId());
        return (UserEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public void create(UserEntity user) {
        this.create(new HashSet<UserEntity>(Collections.singleton(user)));
    }

    @Transactional
    public void create(Set<UserEntity> users) {
        for (UserEntity user : users) {
            ((EntityManager)this.entityManagerProvider.get()).persist((Object)user);
        }
    }

    @Transactional
    public UserEntity merge(UserEntity user) {
        return (UserEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)user);
    }

    @Transactional
    public void merge(Set<UserEntity> users) {
        for (UserEntity user : users) {
            ((EntityManager)this.entityManagerProvider.get()).merge((Object)user);
        }
    }

    @Transactional
    public void remove(UserEntity user) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(user));
        ((EntityManager)this.entityManagerProvider.get()).getEntityManagerFactory().getCache().evictAll();
    }

    @Transactional
    public void remove(Set<UserEntity> users) {
        for (UserEntity userEntity : users) {
            ((EntityManager)this.entityManagerProvider.get()).remove(((EntityManager)this.entityManagerProvider.get()).merge((Object)userEntity));
        }
    }

    @Transactional
    public void removeByPK(Integer userPK) {
        this.remove(this.findByPK(userPK));
    }
}

