/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Set;

@Singleton
public class UserAuthenticationDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public UserAuthenticationEntity findByPK(Long pk) {
        return (UserAuthenticationEntity)((EntityManager)this.entityManagerProvider.get()).find(UserAuthenticationEntity.class, (Object)pk);
    }

    @RequiresSession
    public List<UserAuthenticationEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UserAuthenticationEntity.findAll", UserAuthenticationEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<UserAuthenticationEntity> findByType(UserAuthenticationType authenticationType) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UserAuthenticationEntity.findByType", UserAuthenticationEntity.class);
        query.setParameter("authenticationType", (Object)authenticationType.name());
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<UserAuthenticationEntity> findByTypeAndKey(UserAuthenticationType authenticationType, String key) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UserAuthenticationEntity.findByTypeAndKey", UserAuthenticationEntity.class);
        query.setParameter("authenticationType", (Object)authenticationType.name());
        query.setParameter("authenticationKey", (Object)key);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    public List<UserAuthenticationEntity> findByUser(UserEntity userEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UserAuthenticationEntity.findByUser", UserAuthenticationEntity.class);
        query.setParameter("userId", (Object)userEntity.getUserId());
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(UserAuthenticationEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public void create(Set<UserAuthenticationEntity> entities) {
        for (UserAuthenticationEntity entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
        }
    }

    @Transactional
    public UserAuthenticationEntity merge(UserAuthenticationEntity entity) {
        return (UserAuthenticationEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void merge(Set<UserAuthenticationEntity> entities) {
        for (UserAuthenticationEntity entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
        }
    }

    @Transactional
    public void remove(UserAuthenticationEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
    }

    @Transactional
    public void remove(Set<UserAuthenticationEntity> entities) {
        for (UserAuthenticationEntity entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
        }
    }

    @Transactional
    public void removeByPK(Long pk) {
        this.remove(this.findByPK(pk));
    }
}

