/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.spi.RepositoryType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class UpgradeDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public List<UpgradeEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findAll", UpgradeEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<UpgradeEntity> findUpgrades(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findAllForCluster", UpgradeEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findUpgrade(long upgradeId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findUpgrade", UpgradeEntity.class);
        query.setParameter("upgradeId", (Object)upgradeId);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findUpgradeByRequestId(Long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findUpgradeByRequestId", UpgradeEntity.class);
        query.setParameter("requestId", (Object)requestId);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public void create(UpgradeEntity entity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)entity);
    }

    @Transactional
    public void removeAll(long clusterId) {
        List<UpgradeEntity> entities = this.findUpgrades(clusterId);
        for (UpgradeEntity entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
        }
    }

    @RequiresSession
    public UpgradeGroupEntity findUpgradeGroup(Long groupId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT p FROM UpgradeGroupEntity p WHERE p.upgradeGroupId = :groupId", UpgradeGroupEntity.class);
        query.setParameter("groupId", (Object)groupId);
        return (UpgradeGroupEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeItemEntity findUpgradeItemByRequestAndStage(Long requestId, Long stageId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT p FROM UpgradeItemEntity p WHERE p.stageId = :stageId AND p.upgradeGroupEntity.upgradeEntity.requestId = :requestId", UpgradeItemEntity.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("stageId", (Object)stageId);
        return (UpgradeItemEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findLastUpgradeForCluster(long clusterId, Direction direction) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findLatestForClusterInDirection", UpgradeEntity.class);
        query.setMaxResults(1);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("direction", (Object)direction);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findLastUpgradeOrDowngradeForCluster(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findLatestForCluster", UpgradeEntity.class);
        query.setMaxResults(1);
        query.setParameter("clusterId", (Object)clusterId);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findRevertable(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findRevertable", UpgradeEntity.class);
        query.setMaxResults(1);
        query.setParameter("clusterId", (Object)clusterId);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public UpgradeEntity findRevertableUsingJPQL(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("UpgradeEntity.findRevertableUsingJPQL", UpgradeEntity.class);
        query.setMaxResults(1);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("revertableTypes", (Object)RepositoryType.REVERTABLE);
        return (UpgradeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public UpgradeEntity merge(UpgradeEntity upgradeEntity) {
        return (UpgradeEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)upgradeEntity);
    }
}

