/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.TopologyRequestEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class TopologyRequestDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public TopologyRequestEntity findById(Long id) {
        return (TopologyRequestEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyRequestEntity.class, (Object)id);
    }

    @RequiresSession
    public List<TopologyRequestEntity> findByClusterId(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("TopologyRequestEntity.findByClusterId", TopologyRequestEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<TopologyRequestEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), TopologyRequestEntity.class);
    }

    @RequiresSession
    public List<TopologyRequestEntity> findAllProvisionRequests() {
        return this.daoUtils.selectList(((EntityManager)this.entityManagerProvider.get()).createNamedQuery("TopologyRequestEntity.findProvisionRequests", TopologyRequestEntity.class), new Object[0]);
    }

    @Transactional
    public void create(TopologyRequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestEntity);
    }

    @Transactional
    public TopologyRequestEntity merge(TopologyRequestEntity requestEntity) {
        return (TopologyRequestEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestEntity);
    }

    @Transactional
    public void remove(TopologyRequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)requestEntity);
    }

    @Transactional
    public void removeByPK(Long requestId) {
        this.remove(this.findById(requestId));
    }

    @Transactional
    public void removeAll(Long clusterId) {
        List<TopologyRequestEntity> clusterTopologyRequests = this.findByClusterId(clusterId);
        for (TopologyRequestEntity topologyRequestEntity : clusterTopologyRequests) {
            this.remove(topologyRequestEntity);
        }
    }
}

