/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class TopologyLogicalTaskDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public TopologyLogicalTaskEntity findById(Long id) {
        return (TopologyLogicalTaskEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyLogicalTaskEntity.class, (Object)id);
    }

    @RequiresSession
    public Set<Long> findHostTaskIdsByPhysicalTaskIds(Set<Long> physicalTaskIds) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        HashSet result = new HashSet();
        TypedQuery topologyHostTaskQuery = entityManager.createNamedQuery("TopologyLogicalTaskEntity.findHostTaskIdsByPhysicalTaskIds", Long.class);
        SQLOperations.batch(physicalTaskIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            topologyHostTaskQuery.setParameter("physicalTaskIds", (Object)chunk);
            result.addAll(this.daoUtils.selectList(topologyHostTaskQuery, new Object[0]));
            return 0;
        });
        return Sets.newHashSet(result);
    }

    @RequiresSession
    public List<TopologyLogicalTaskEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), TopologyLogicalTaskEntity.class);
    }

    @Transactional
    public void create(TopologyLogicalTaskEntity logicalTaskEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)logicalTaskEntity);
    }

    @Transactional
    public TopologyLogicalTaskEntity merge(TopologyLogicalTaskEntity logicalTaskEntity) {
        return (TopologyLogicalTaskEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)logicalTaskEntity);
    }

    @Transactional
    public void remove(TopologyLogicalTaskEntity logicalTaskEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)logicalTaskEntity);
    }
}

