/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.TopologyLogicalRequestEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class TopologyLogicalRequestDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public TopologyLogicalRequestEntity findById(Long id) {
        return (TopologyLogicalRequestEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyLogicalRequestEntity.class, (Object)id);
    }

    @RequiresSession
    public List<TopologyLogicalRequestEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), TopologyLogicalRequestEntity.class);
    }

    @Transactional
    public void create(TopologyLogicalRequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestEntity);
    }

    @Transactional
    public TopologyLogicalRequestEntity merge(TopologyLogicalRequestEntity requestEntity) {
        return (TopologyLogicalRequestEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestEntity);
    }

    @Transactional
    public void remove(TopologyLogicalRequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)requestEntity);
    }

    @RequiresSession
    public Set<Long> findRequestIdsByIds(Set<Long> ids) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        HashSet result = new HashSet();
        TypedQuery topologyLogicalRequestQuery = entityManager.createNamedQuery("TopologyLogicalRequestEntity.findRequestIds", Long.class);
        SQLOperations.batch(ids, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            topologyLogicalRequestQuery.setParameter("ids", (Object)chunk);
            result.addAll(this.daoUtils.selectList(topologyLogicalRequestQuery, new Object[0]));
            return 0;
        });
        return Sets.newHashSet(result);
    }
}

