/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.TopologyHostTaskEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class TopologyHostTaskDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public TopologyHostTaskEntity findById(Long id) {
        return (TopologyHostTaskEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyHostTaskEntity.class, (Object)id);
    }

    @RequiresSession
    public Collection<TopologyHostTaskEntity> findByHostRequest(Long id) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("TopologyHostTaskEntity.findByHostRequest", TopologyHostTaskEntity.class);
        query.setParameter("hostRequestId", (Object)id);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public Set<Long> findHostRequestIdsByHostTaskIds(Set<Long> hostTaskIds) {
        HashSet result = new HashSet();
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery topologyHostTaskQuery = entityManager.createNamedQuery("TopologyLogicalTaskEntity.findHostRequestIdsByHostTaskIds", Long.class);
        SQLOperations.batch(hostTaskIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            topologyHostTaskQuery.setParameter("hostTaskIds", (Object)chunk);
            result.addAll(this.daoUtils.selectList(topologyHostTaskQuery, new Object[0]));
            return 0;
        });
        return Sets.newHashSet(result);
    }

    @RequiresSession
    public List<TopologyHostTaskEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), TopologyHostTaskEntity.class);
    }

    @Transactional
    public void create(TopologyHostTaskEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestEntity);
    }

    @Transactional
    public TopologyHostTaskEntity merge(TopologyHostTaskEntity requestEntity) {
        return (TopologyHostTaskEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestEntity);
    }

    @Transactional
    public void remove(TopologyHostTaskEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)requestEntity);
    }
}

