/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostInfoEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;

@Singleton
public class TopologyHostInfoDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public TopologyHostInfoEntity findById(long hostInfoId) {
        return (TopologyHostInfoEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyHostInfoEntity.class, (Object)hostInfoId);
    }

    @RequiresSession
    public List<TopologyHostInfoEntity> findByHost(HostEntity host) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostInfo FROM TopologyHostInfoEntity hostInfo where hostInfo.hostEntity=:host", TopologyHostInfoEntity.class);
        query.setParameter("host", (Object)host);
        try {
            return query.getResultList();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<TopologyHostInfoEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostInfo FROM TopologyHostInfoEntity hostInfo", TopologyHostInfoEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    @Transactional
    public void refresh(TopologyHostInfoEntity topologyHostInfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)topologyHostInfoEntity);
    }

    @Transactional
    public void create(TopologyHostInfoEntity topologyHostInfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)topologyHostInfoEntity);
    }

    @Transactional
    public TopologyHostInfoEntity merge(TopologyHostInfoEntity topologyHostInfoEntity) {
        return (TopologyHostInfoEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)topologyHostInfoEntity);
    }

    @Transactional
    public void remove(TopologyHostInfoEntity topologyHostInfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(topologyHostInfoEntity));
    }

    @Transactional
    public void removeByHost(HostEntity host) {
        for (TopologyHostInfoEntity e : this.findByHost(host)) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(e));
        }
    }

    public TopologyHostInfoEntity findByHostname(String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostInfo FROM TopologyHostInfoEntity hostInfo where hostInfo.fqdn=:hostName", TopologyHostInfoEntity.class);
        query.setParameter("hostName", (Object)hostName);
        try {
            return (TopologyHostInfoEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }
}

