/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.TopologyHostGroupEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class TopologyHostGroupDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public TopologyHostGroupEntity findById(Long id) {
        return (TopologyHostGroupEntity)((EntityManager)this.entityManagerProvider.get()).find(TopologyHostGroupEntity.class, (Object)id);
    }

    @RequiresSession
    public TopologyHostGroupEntity findByRequestIdAndName(long topologyRequestId, String name) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("TopologyHostGroupEntity.findByRequestIdAndName", TopologyHostGroupEntity.class);
        query.setParameter("requestId", (Object)topologyRequestId);
        query.setParameter("name", (Object)name);
        return (TopologyHostGroupEntity)query.getSingleResult();
    }

    @RequiresSession
    public List<TopologyHostGroupEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), TopologyHostGroupEntity.class);
    }

    @Transactional
    public void create(TopologyHostGroupEntity hostGroupEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)hostGroupEntity);
    }

    @Transactional
    public TopologyHostGroupEntity merge(TopologyHostGroupEntity hostGroupEntity) {
        return (TopologyHostGroupEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)hostGroupEntity);
    }

    @Transactional
    public void remove(TopologyHostGroupEntity hostGroupEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)hostGroupEntity);
    }
}

