/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.api.query.JpaPredicateVisitor;
import id.onyx.obdp.server.api.query.JpaSortBuilder;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.StageEntityPK;
import id.onyx.obdp.server.orm.entities.StageEntity_;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import id.onyx.obdp.server.utils.StageUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

@Singleton
public class StageDAO {
    private static Map<HostRoleStatus, EnumSet<HostRoleStatus>> manualTransitionMap = new HashMap<HostRoleStatus, EnumSet<HostRoleStatus>>();
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;
    @Inject
    HostRoleCommandDAO hostRoleCommandDao;

    @RequiresSession
    public StageEntity findByPK(StageEntityPK stageEntityPK) {
        return (StageEntity)((EntityManager)this.entityManagerProvider.get()).find(StageEntity.class, (Object)stageEntityPK);
    }

    @RequiresSession
    public List<StageEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), StageEntity.class);
    }

    @RequiresSession
    public long getLastRequestId() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT max(stage.requestId) FROM StageEntity stage", Long.class);
        Long result = (Long)this.daoUtils.selectSingle(query, new Object[0]);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    @RequiresSession
    public StageEntity findByActionId(String actionId) {
        long[] ids = StageUtils.getRequestStage(actionId);
        StageEntityPK pk = new StageEntityPK();
        pk.setRequestId(ids[0]);
        pk.setStageId(ids[1]);
        return this.findByPK(pk);
    }

    @RequiresSession
    public List<StageEntity> findByRequestId(long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT stage FROM StageEntity stage WHERE stage.requestId=?1 ORDER BY stage.stageId", StageEntity.class);
        return this.daoUtils.selectList(query, requestId);
    }

    @RequiresSession
    public List<StageEntity> findByRequestIdAndCommandStatuses(Long requestId, Collection<HostRoleStatus> statuses) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("StageEntity.findByRequestIdAndCommandStatuses", StageEntity.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("statuses", statuses);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<StageEntity> findFirstStageByStatus(Collection<HostRoleStatus> statuses) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("StageEntity.findFirstStageByStatus", Object[].class);
        query.setParameter("statuses", statuses);
        List results = this.daoUtils.selectList(query, new Object[0]);
        ArrayList<StageEntity> stages = new ArrayList<StageEntity>();
        for (Object[] result : results) {
            StageEntityPK stagePK = new StageEntityPK();
            stagePK.setRequestId((Long)result[0]);
            stagePK.setStageId((Long)result[1]);
            StageEntity stage = this.findByPK(stagePK);
            stages.add(stage);
        }
        return stages;
    }

    @RequiresSession
    public Map<Long, String> findRequestContext(List<Long> requestIds) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(requestIds)) {
            TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT stage FROM StageEntity stage WHERE stage.requestId IN (SELECT DISTINCT s.requestId FROM StageEntity s WHERE s.requestId IN ?1)", StageEntity.class);
            ArrayList result = new ArrayList();
            SQLOperations.batch(requestIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
                result.addAll(this.daoUtils.selectList(query, chunk));
                return 0;
            });
            for (StageEntity entity : result) {
                resultMap.put(entity.getRequestId(), entity.getRequestContext());
            }
        }
        return resultMap;
    }

    @RequiresSession
    public String findRequestContext(long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT stage.requestContext FROM StageEntity stage WHERE stage.requestId=?1", String.class);
        String result = (String)this.daoUtils.selectOne(query, requestId);
        if (result != null) {
            return result;
        }
        return "";
    }

    @Transactional
    public void create(StageEntity stageEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)stageEntity);
    }

    @Transactional
    public StageEntity merge(StageEntity stageEntity) {
        return (StageEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)stageEntity);
    }

    @Transactional
    public void remove(StageEntity stageEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(stageEntity));
    }

    @Transactional
    public void removeByPK(StageEntityPK stageEntityPK) {
        this.remove(this.findByPK(stageEntityPK));
    }

    @RequiresSession
    public List<StageEntity> findAll(Request request, id.onyx.obdp.server.controller.spi.Predicate predicate) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        StagePredicateVisitor visitor = new StagePredicateVisitor();
        PredicateHelper.visit(predicate, visitor);
        CriteriaQuery query = visitor.getCriteriaQuery();
        Predicate jpaPredicate = visitor.getJpaPredicate();
        if (jpaPredicate != null) {
            query.where((Expression)jpaPredicate);
        }
        JpaSortBuilder<StageEntity> sortBuilder = new JpaSortBuilder<StageEntity>();
        List<Order> sortOrders = sortBuilder.buildSortOrders(request.getSortRequest(), visitor);
        query.orderBy(sortOrders);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setHint("eclipselink.refresh", (Object)"True");
        return this.daoUtils.selectList(typedQuery, new Object[0]);
    }

    @Transactional
    public void updateStageStatus(StageEntity stage, HostRoleStatus desiredStatus, ActionManager actionManager) {
        Collection<HostRoleCommandEntity> tasks = stage.getHostRoleCommands();
        HostRoleStatus currentStatus = CalculatedStatus.statusFromTaskEntities(tasks, stage.isSkippable()).getStatus();
        if (!StageDAO.isValidManualTransition(currentStatus, desiredStatus)) {
            throw new IllegalArgumentException("Can not transition a stage from " + currentStatus + " to " + desiredStatus);
        }
        if (desiredStatus == HostRoleStatus.ABORTED) {
            actionManager.cancelRequest(stage.getRequestId(), "User aborted.");
        } else {
            ArrayList<HostRoleCommandEntity> hrcWithChangedStatus = new ArrayList<HostRoleCommandEntity>();
            for (HostRoleCommandEntity hostRoleCommand : tasks) {
                HostRoleStatus hostRoleStatus = hostRoleCommand.getStatus();
                if (!hostRoleStatus.equals((Object)currentStatus)) continue;
                hrcWithChangedStatus.add(hostRoleCommand);
                hostRoleCommand.setStatus(desiredStatus);
                if (desiredStatus == HostRoleStatus.PENDING) {
                    hostRoleCommand.setStartTime(-1L);
                }
                this.hostRoleCommandDao.merge(hostRoleCommand);
            }
        }
    }

    @Transactional
    public void updateStatus(StageEntityPK stageEntityPK, HostRoleStatus status, HostRoleStatus displayStatus) {
        StageEntity stageEntity = this.findByPK(stageEntityPK);
        stageEntity.setStatus(status);
        stageEntity.setDisplayStatus(displayStatus);
        this.merge(stageEntity);
    }

    private static boolean isValidManualTransition(HostRoleStatus status, HostRoleStatus desiredStatus) {
        EnumSet<HostRoleStatus> stageStatusSet = manualTransitionMap.get((Object)status);
        return stageStatusSet != null && stageStatusSet.contains((Object)desiredStatus);
    }

    static {
        manualTransitionMap.put(HostRoleStatus.HOLDING, EnumSet.of(HostRoleStatus.COMPLETED, HostRoleStatus.ABORTED));
        manualTransitionMap.put(HostRoleStatus.HOLDING_FAILED, EnumSet.of(HostRoleStatus.PENDING, HostRoleStatus.FAILED, HostRoleStatus.ABORTED));
        manualTransitionMap.put(HostRoleStatus.HOLDING_TIMEDOUT, EnumSet.of(HostRoleStatus.PENDING, HostRoleStatus.TIMEDOUT, HostRoleStatus.ABORTED));
    }

    private final class StagePredicateVisitor
    extends JpaPredicateVisitor<StageEntity> {
        public StagePredicateVisitor() {
            super((EntityManager)StageDAO.this.entityManagerProvider.get(), StageEntity.class);
        }

        @Override
        public Class<StageEntity> getEntityClass() {
            return StageEntity.class;
        }

        @Override
        public List<? extends SingularAttribute<?, ?>> getPredicateMapping(String propertyId) {
            return StageEntity_.getPredicateMapping().get(propertyId);
        }
    }
}

