/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class StackDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public StackEntity findById(long stackId) {
        return (StackEntity)((EntityManager)this.entityManagerProvider.get()).find(StackEntity.class, (Object)stackId);
    }

    @RequiresSession
    public List<StackEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("StackEntity.findAll", StackEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public StackEntity find(String stackName, String stackVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("StackEntity.findByNameAndVersion", StackEntity.class);
        query.setParameter("stackName", (Object)stackName);
        query.setParameter("stackVersion", (Object)stackVersion);
        return (StackEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public StackEntity find(StackId stackId) {
        return this.find(stackId.getStackName(), stackId.getStackVersion());
    }

    @Transactional
    public void create(StackEntity stack) throws OBDPException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)stack);
    }

    @Transactional
    public void refresh(StackEntity stack) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)stack);
    }

    @Transactional
    public StackEntity merge(StackEntity stack) {
        return (StackEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)stack);
    }

    public void createOrUpdate(StackEntity stack) throws OBDPException {
        if (null == stack.getStackId()) {
            this.create(stack);
        } else {
            this.merge(stack);
        }
    }

    @Transactional
    public void remove(StackEntity stack) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        if (null != (stack = this.findById(stack.getStackId()))) {
            entityManager.remove((Object)stack);
        }
    }

    @Transactional
    public void removeByMpack(Long mpackId) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByMpack(mpackId));
    }

    public StackEntity findByMpack(Long mpackId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("StackEntity.findByMpack", StackEntity.class);
        query.setParameter("mpackId", (Object)mpackId);
        return (StackEntity)this.daoUtils.selectOne(query, new Object[0]);
    }
}

