/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.SettingEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Singleton
public class SettingDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public SettingEntity findByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("settingByName", SettingEntity.class);
        query.setParameter("name", (Object)name);
        return (SettingEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public List<SettingEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), SettingEntity.class);
    }

    @Transactional
    public void create(SettingEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public SettingEntity merge(SettingEntity entity) {
        return (SettingEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void removeByName(String name) {
        SettingEntity entity = this.findByName(name);
        if (entity != null) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
        }
    }
}

