/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

@Singleton
public class ServiceConfigDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private StackDAO stackDAO;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public ServiceConfigEntity find(Long serviceConfigId) {
        return (ServiceConfigEntity)((EntityManager)this.entityManagerProvider.get()).find(ServiceConfigEntity.class, (Object)serviceConfigId);
    }

    @RequiresSession
    public ServiceConfigEntity findByServiceAndVersion(String serviceName, Long version) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scv FROM ServiceConfigEntity scv WHERE scv.serviceName=?1 AND scv.version=?2", ServiceConfigEntity.class);
        return (ServiceConfigEntity)this.daoUtils.selectOne(query, serviceName, version);
    }

    @RequiresSession
    public List<ServiceConfigEntity> findByService(Long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId=?1 AND scv.serviceName=?2", ServiceConfigEntity.class);
        return this.daoUtils.selectList(query, clusterId, serviceName);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getLastServiceConfigVersionsForGroups(Collection<Long> configGroupIds) {
        if (configGroupIds == null || configGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = ((EntityManager)this.entityManagerProvider.get()).getCriteriaBuilder();
        CriteriaQuery cq = cb.createTupleQuery();
        Root groupVersion = cq.from(ServiceConfigEntity.class);
        cq.multiselect(new Selection[]{groupVersion.get("groupId").alias("groupId"), cb.max((Expression)groupVersion.get("version")).alias("lastVersion")});
        cq.where((Expression)groupVersion.get("groupId").in(configGroupIds));
        cq.groupBy(new Expression[]{groupVersion.get("groupId")});
        List tuples = this.daoUtils.selectList(((EntityManager)this.entityManagerProvider.get()).createQuery(cq), new Object[0]);
        ArrayList<ServiceConfigEntity> result = new ArrayList<ServiceConfigEntity>();
        for (Tuple tuple : tuples) {
            CriteriaQuery sce = cb.createQuery(ServiceConfigEntity.class);
            Root sceRoot = sce.from(ServiceConfigEntity.class);
            sce.where((Expression)cb.and((Expression)cb.equal((Expression)sceRoot.get("groupId"), tuple.get("groupId")), (Expression)cb.equal((Expression)sceRoot.get("version"), tuple.get("lastVersion"))));
            sce.select((Selection)sceRoot);
            result.add((ServiceConfigEntity)this.daoUtils.selectSingle(((EntityManager)this.entityManagerProvider.get()).createQuery(sce), new Object[0]));
        }
        return result;
    }

    @RequiresSession
    public ServiceConfigEntity getLastServiceConfigVersionsForGroup(Long configGroupId) {
        if (configGroupId == null) {
            return null;
        }
        List<ServiceConfigEntity> result = this.getLastServiceConfigVersionsForGroups(new ArrayList<Long>(Arrays.asList(configGroupId)));
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @RequiresSession
    public List<Long> getServiceConfigVersionsByConfig(Long clusterId, String configType, Long configVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scv.version FROM ServiceConfigEntity scv JOIN scv.clusterConfigEntities cc WHERE cc.clusterId=?1 AND cc.type = ?2 AND cc.version = ?3", Long.class);
        return this.daoUtils.selectList(query, clusterId, configType, configVersion);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getLastServiceConfigs(Long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findLatestServiceConfigsByCluster", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getLastServiceConfigsForService(Long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findLatestServiceConfigsByService", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ServiceConfigEntity getLastServiceConfigForServiceDefaultGroup(Long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findLatestServiceConfigsByServiceDefaultGroup", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        return (ServiceConfigEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getServiceConfigsForServiceAndStack(Long clusterId, StackId stackId, String serviceName) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findAllServiceConfigsByStack", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("stack", (Object)stackEntity);
        query.setParameter("serviceName", (Object)serviceName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getLatestServiceConfigs(Long clusterId, StackId stackId) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findLatestServiceConfigsByStack", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("stack", (Object)stackEntity);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ServiceConfigEntity getLastServiceConfig(Long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId = ?1 AND scv.serviceName = ?2 ORDER BY scv.createTimestamp DESC", ServiceConfigEntity.class);
        return (ServiceConfigEntity)this.daoUtils.selectOne(query, clusterId, serviceName);
    }

    @RequiresSession
    public ServiceConfigEntity findMaxVersion(Long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId=?1 AND scv.serviceName=?2 AND scv.version = (SELECT max(scv2.version) FROM ServiceConfigEntity scv2 WHERE scv2.clusterId=?1 AND scv2.serviceName=?2)", ServiceConfigEntity.class);
        return (ServiceConfigEntity)this.daoUtils.selectSingle(query, clusterId, serviceName);
    }

    @RequiresSession
    public List<ServiceConfigEntity> getServiceConfigs(Long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findAll", ServiceConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ServiceConfigEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), ServiceConfigEntity.class);
    }

    @RequiresSession
    public Long findNextServiceConfigVersion(long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ServiceConfigEntity.findNextServiceConfigVersion", Number.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        return ((Number)this.daoUtils.selectSingle(query, new Object[0])).longValue();
    }

    @Transactional
    public void removeHostFromServiceConfigs(final Long hostId) {
        List<ServiceConfigEntity> allServiceConfigs = this.findAll();
        for (ServiceConfigEntity serviceConfigEntity : allServiceConfigs) {
            List<Long> hostIds = serviceConfigEntity.getHostIds();
            if (hostIds == null || !hostIds.contains(hostId)) continue;
            CollectionUtils.filter(hostIds, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((Long)arg0).equals(hostId);
                }
            });
            serviceConfigEntity.setHostIds(hostIds);
        }
    }

    @Transactional
    public void create(ServiceConfigEntity serviceConfigEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)serviceConfigEntity);
    }

    @Transactional
    public ServiceConfigEntity merge(ServiceConfigEntity serviceConfigEntity) {
        return (ServiceConfigEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)serviceConfigEntity);
    }

    @Transactional
    public void remove(ServiceConfigEntity serviceConfigEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(serviceConfigEntity));
    }
}

