/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentVersionEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

@Singleton
public class ServiceComponentDesiredStateDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public ServiceComponentDesiredStateEntity findById(long id) {
        return (ServiceComponentDesiredStateEntity)((EntityManager)this.entityManagerProvider.get()).find(ServiceComponentDesiredStateEntity.class, (Object)id);
    }

    @RequiresSession
    public List<ServiceComponentDesiredStateEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT scd from ServiceComponentDesiredStateEntity scd", ServiceComponentDesiredStateEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public ServiceComponentDesiredStateEntity findByName(long clusterId, String serviceName, String componentName) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery("ServiceComponentDesiredStateEntity.findByName", ServiceComponentDesiredStateEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        ServiceComponentDesiredStateEntity entity = null;
        List entities = this.daoUtils.selectList(query, new Object[0]);
        if (null != entities && !entities.isEmpty()) {
            entity = (ServiceComponentDesiredStateEntity)entities.get(0);
        }
        return entity;
    }

    @RequiresSession
    public List<ServiceComponentDesiredStateEntity> findByNames(Map<Long, Map<String, List<String>>> serviceComponentDesiredStates) {
        if (MapUtils.isEmpty(serviceComponentDesiredStates)) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = ((EntityManager)this.entityManagerProvider.get()).getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(ServiceComponentDesiredStateEntity.class);
        Root desiredStates = cq.from(ServiceComponentDesiredStateEntity.class);
        ArrayList<Predicate> clusters = new ArrayList<Predicate>();
        for (Map.Entry<Long, Map<String, List<String>>> cluster : serviceComponentDesiredStates.entrySet()) {
            ArrayList<Predicate> services = new ArrayList<Predicate>();
            for (Map.Entry<String, List<String>> service : cluster.getValue().entrySet()) {
                services.add(cb.and((Expression)cb.equal((Expression)desiredStates.get("serviceName"), (Object)service.getKey()), (Expression)desiredStates.get("componentName").in((Collection)service.getValue())));
            }
            clusters.add(cb.and((Expression)cb.equal((Expression)desiredStates.get("clusterId"), (Object)cluster.getKey()), (Expression)cb.or(services.toArray(new Predicate[services.size()]))));
        }
        cq.where((Expression)cb.or(clusters.toArray(new Predicate[clusters.size()])));
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(cq);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void refresh(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)serviceComponentDesiredStateEntity);
    }

    @Transactional
    public void create(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)serviceComponentDesiredStateEntity);
    }

    @Transactional
    public ServiceComponentDesiredStateEntity merge(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        return (ServiceComponentDesiredStateEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)serviceComponentDesiredStateEntity);
    }

    @Transactional
    public void remove(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)serviceComponentDesiredStateEntity);
    }

    @Transactional
    public void removeByName(long clusterId, String serviceName, String componentName) {
        ServiceComponentDesiredStateEntity entity = this.findByName(clusterId, serviceName, componentName);
        if (null != entity) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
        }
    }

    @RequiresSession
    public List<ServiceComponentVersionEntity> findVersions(long clusterId, String serviceName, String componentName) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery("ServiceComponentVersionEntity.findByComponent", ServiceComponentVersionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ServiceComponentVersionEntity findVersion(long clusterId, String serviceName, String componentName, String version) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery("ServiceComponentVersionEntity.findByComponentAndVersion", ServiceComponentVersionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("repoVersion", (Object)version);
        return (ServiceComponentVersionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }
}

