/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ResourceTypeDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ResourceTypeEntity findById(Integer id) {
        return (ResourceTypeEntity)((EntityManager)this.entityManagerProvider.get()).find(ResourceTypeEntity.class, (Object)id);
    }

    @RequiresSession
    public ResourceTypeEntity findByName(String name) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT resourceType FROM ResourceTypeEntity resourceType WHERE resourceType.name = ?1", ResourceTypeEntity.class);
        return (ResourceTypeEntity)this.daoUtils.selectSingle(query, name);
    }

    @RequiresSession
    public List<ResourceTypeEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT resourceType FROM ResourceTypeEntity resourceType", ResourceTypeEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(ResourceTypeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public ResourceTypeEntity merge(ResourceTypeEntity entity) {
        return (ResourceTypeEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }
}

