/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ResourceDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ResourceEntity findById(Long id) {
        return (ResourceEntity)((EntityManager)this.entityManagerProvider.get()).find(ResourceEntity.class, (Object)id);
    }

    @RequiresSession
    public ResourceEntity findByResourceTypeId(Integer id) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT resource FROM ResourceEntity resource WHERE resource.resourceType.id =:resourceTypeId", ResourceEntity.class);
        query.setParameter("resourceTypeId", (Object)id);
        try {
            return (ResourceEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @RequiresSession
    public List<ResourceEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT resource FROM ResourceEntity resource", ResourceEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(ResourceEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public ResourceEntity merge(ResourceEntity entity) {
        return (ResourceEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    public ResourceEntity findAmbariResource() {
        return this.findById(1L);
    }
}

