/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class RequestScheduleDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public RequestScheduleEntity findById(Long id) {
        return (RequestScheduleEntity)((EntityManager)this.entityManagerProvider.get()).find(RequestScheduleEntity.class, (Object)id);
    }

    @RequiresSession
    public List<RequestScheduleEntity> findByStatus(String status) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("reqScheduleByStatus", RequestScheduleEntity.class);
        query.setParameter("status", (Object)status);
        try {
            return query.getResultList();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<RequestScheduleEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allReqSchedules", RequestScheduleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @Transactional
    public void create(RequestScheduleEntity requestScheduleEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestScheduleEntity);
    }

    @Transactional
    public RequestScheduleEntity merge(RequestScheduleEntity requestScheduleEntity) {
        return (RequestScheduleEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestScheduleEntity);
    }

    @Transactional
    public void remove(RequestScheduleEntity requestScheduleEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(requestScheduleEntity));
    }

    @Transactional
    public void removeByPK(Long id) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findById(id));
    }

    @Transactional
    public void refresh(RequestScheduleEntity requestScheduleEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)requestScheduleEntity);
    }
}

