/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.RequestScheduleBatchRequestEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleBatchRequestEntityPK;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class RequestScheduleBatchRequestDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public RequestScheduleBatchRequestEntity findByPk(RequestScheduleBatchRequestEntityPK batchRequestEntity) {
        return (RequestScheduleBatchRequestEntity)((EntityManager)this.entityManagerProvider.get()).find(RequestScheduleBatchRequestEntity.class, (Object)batchRequestEntity);
    }

    @RequiresSession
    public List<RequestScheduleBatchRequestEntity> findByScheduleId(Long scheduleId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findByScheduleId", RequestScheduleBatchRequestEntity.class);
        query.setParameter("id", (Object)scheduleId);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public List<RequestScheduleBatchRequestEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), RequestScheduleBatchRequestEntity.class);
    }

    @Transactional
    public void create(RequestScheduleBatchRequestEntity batchRequestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)batchRequestEntity);
    }

    @Transactional
    public RequestScheduleBatchRequestEntity merge(RequestScheduleBatchRequestEntity batchRequestEntity) {
        return (RequestScheduleBatchRequestEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)batchRequestEntity);
    }

    @Transactional
    public void refresh(RequestScheduleBatchRequestEntity batchRequestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)batchRequestEntity);
    }

    @Transactional
    public void remove(RequestScheduleBatchRequestEntity batchRequestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(batchRequestEntity));
    }

    @Transactional
    public void removeByPk(RequestScheduleBatchRequestEntityPK batchRequestEntityPK) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByPk(batchRequestEntityPK));
    }

    @Transactional
    public void removeByScheduleId(Long scheduleId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("DELETE FROM RequestScheduleBatchRequestEntity batchreq WHERE batchreq.scheduleId = ?1", Long.class);
        this.daoUtils.executeUpdate((Query)query, scheduleId);
        ((EntityManager)this.entityManagerProvider.get()).flush();
    }
}

