/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.RequestOperationLevelEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class RequestOperationLevelDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public List<RequestOperationLevelEntity> findByHostId(Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("requestOperationLevelByHostId", RequestOperationLevelEntity.class);
        query.setParameter("hostId", (Object)hostId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<RequestOperationLevelEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), RequestOperationLevelEntity.class);
    }

    @Transactional
    public void refresh(RequestOperationLevelEntity requestOperationLevelEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)requestOperationLevelEntity);
    }

    @Transactional
    public void create(RequestOperationLevelEntity requestOperationLevelEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestOperationLevelEntity);
    }

    @Transactional
    public RequestOperationLevelEntity merge(RequestOperationLevelEntity requestOperationLevelEntity) {
        return (RequestOperationLevelEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestOperationLevelEntity);
    }

    @Transactional
    public void remove(RequestOperationLevelEntity requestOperationLevelEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(requestOperationLevelEntity));
    }

    @Transactional
    public void removeByHostId(Long hostId) {
        List<RequestOperationLevelEntity> hostRequestOpLevels = this.findByHostId(hostId);
        for (RequestOperationLevelEntity hostRequestOpLevel : hostRequestOpLevels) {
            this.remove(hostRequestOpLevel);
        }
    }
}

