/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.cleanup.TimeBasedCleanupPolicy;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.Cleanable;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostTaskDAO;
import id.onyx.obdp.server.orm.dao.TopologyLogicalRequestDAO;
import id.onyx.obdp.server.orm.dao.TopologyLogicalTaskDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.entities.ExecutionCommandEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RequestOperationLevelEntity;
import id.onyx.obdp.server.orm.entities.RequestResourceFilterEntity;
import id.onyx.obdp.server.orm.entities.RoleSuccessCriteriaEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostTaskEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import id.onyx.obdp.server.state.Clusters;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestDAO
implements Cleanable {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDAO.class);
    private static final String REQUEST_IDS_SORTED_SQL = "SELECT request.requestId FROM RequestEntity request ORDER BY request.requestId {0}";
    private static final String REQUESTS_WITH_CLUSTER_SQL = "SELECT request.requestId FROM RequestEntity request WHERE request.clusterId = %s ORDER BY request.requestId %s";
    private static final String REQUESTS_WITH_NO_CLUSTER_SQL = "SELECT request.requestId FROM RequestEntity request WHERE request.clusterId = -1 OR request.clusterId IS NULL ORDER BY request.requestId %s";
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private TopologyLogicalTaskDAO topologyLogicalTaskDAO;
    @Inject
    private TopologyHostTaskDAO topologyHostTaskDAO;
    @Inject
    private TopologyLogicalRequestDAO topologyLogicalRequestDAO;
    @Inject
    private TopologyRequestDAO topologyRequestDAO;

    @RequiresSession
    public RequestEntity findByPK(Long requestId) {
        return (RequestEntity)((EntityManager)this.entityManagerProvider.get()).find(RequestEntity.class, (Object)requestId);
    }

    @RequiresSession
    public List<RequestEntity> findByPks(Collection<Long> requestIds) {
        return this.findByPks(requestIds, false);
    }

    @RequiresSession
    public List<RequestEntity> findByPks(Collection<Long> requestIds, boolean refreshHint) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT request FROM RequestEntity request WHERE request.requestId IN ?1", RequestEntity.class);
        if (refreshHint) {
            query.setHint("eclipselink.refresh", (Object)"True");
        }
        ArrayList result = new ArrayList();
        SQLOperations.batch(requestIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            result.addAll(this.daoUtils.selectList(query, chunk));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<RequestEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), RequestEntity.class);
    }

    @RequiresSession
    public List<Long> findAllRequestIds(int limit, boolean ascending) {
        String sort = "ASC";
        if (!ascending) {
            sort = "DESC";
        }
        String sql = MessageFormat.format(REQUEST_IDS_SORTED_SQL, sort);
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(sql, Long.class);
        query.setMaxResults(limit);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<RequestResourceFilterEntity> findAllResourceFilters() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), RequestResourceFilterEntity.class);
    }

    @RequiresSession
    public boolean isAllTasksCompleted(long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT task.taskId FROM HostRoleCommandEntity task WHERE task.requestId = ?1 AND task.stageId=(select max(stage.stageId) FROM StageEntity stage WHERE stage.requestId=?1) AND task.status NOT IN ?2", Long.class);
        query.setMaxResults(1);
        return this.daoUtils.selectList(query, requestId, HostRoleStatus.getCompletedStates()).isEmpty();
    }

    @RequiresSession
    public Long getLastStageId(long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT max(stage.stageId) FROM StageEntity stage WHERE stage.requestId=?1", Long.class);
        return (Long)this.daoUtils.selectSingle(query, requestId);
    }

    @Transactional
    public RequestEntity updateStatus(long requestId, HostRoleStatus status, HostRoleStatus displayStatus) {
        RequestEntity requestEntity = this.findByPK(requestId);
        requestEntity.setStatus(status);
        requestEntity.setDisplayStatus(displayStatus);
        return this.merge(requestEntity);
    }

    @Transactional
    public void create(RequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)requestEntity);
    }

    @Transactional
    public RequestEntity merge(RequestEntity requestEntity) {
        return (RequestEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)requestEntity);
    }

    @Transactional
    public void remove(RequestEntity requestEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(requestEntity));
    }

    @Transactional
    public void removeByPK(Long requestId) {
        this.remove(this.findByPK(requestId));
    }

    @RequiresSession
    public List<Long> findAllRequestIds(int limit, boolean sortAscending, Long clusterId) {
        String sql = null == clusterId ? String.format(REQUESTS_WITH_NO_CLUSTER_SQL, sortAscending ? "ASC" : "DESC") : String.format(REQUESTS_WITH_CLUSTER_SQL, clusterId, sortAscending ? "ASC" : "DESC");
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(sql, Long.class);
        query.setMaxResults(limit);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    private Set<Long> findAllRequestIdsFromUpgrade() {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery upgradeQuery = entityManager.createNamedQuery("UpgradeEntity.findAllRequestIds", Long.class);
        return Sets.newHashSet(this.daoUtils.selectList(upgradeQuery, new Object[0]));
    }

    public List<StageEntityPK> findRequestAndStageIdsInClusterBeforeDate(Long clusterId, long beforeDateMillis) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery requestQuery = entityManager.createNamedQuery("RequestEntity.findRequestStageIdsInClusterBeforeDate", StageEntityPK.class);
        requestQuery.setParameter("clusterId", (Object)clusterId);
        requestQuery.setParameter("beforeDate", (Object)beforeDateMillis);
        return this.daoUtils.selectList(requestQuery, new Object[0]);
    }

    @Transactional
    protected <T> int cleanTableByIds(Set<Long> ids, String paramName, String entityName, Long beforeDateMillis, String entityQuery, Class<T> type) {
        LOG.info(String.format("Purging %s entity records before date %s", entityName, new Date(beforeDateMillis)));
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery(entityQuery, type);
        return SQLOperations.batch(ids, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            LOG.info(String.format("Purging %s entity, batch %s/%s.", entityName, currentBatch, totalBatches));
            query.setParameter(paramName, (Object)chunk);
            return query.executeUpdate();
        });
    }

    @Transactional
    protected <T> int cleanTableByStageEntityPK(List<StageEntityPK> ids, LinkedList<String> paramNames, String entityName, Long beforeDateMillis, String entityQuery, Class<T> type) {
        LOG.info(String.format("Purging %s entity records before date %s", entityName, new Date(beforeDateMillis)));
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery(entityQuery, type);
        return SQLOperations.batch(ids, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            int affectedRows = 0;
            for (StageEntityPK requestIds : chunk) {
                query.setParameter((String)paramNames.get(0), (Object)requestIds.getStageId());
                query.setParameter((String)paramNames.get(1), (Object)requestIds.getRequestId());
                affectedRows += query.executeUpdate();
            }
            return affectedRows;
        });
    }

    @Override
    @Transactional
    public long cleanup(TimeBasedCleanupPolicy policy) {
        HashSet<Long> requestIds;
        long affectedRows = 0L;
        try {
            Long clusterId = ((Clusters)this.m_clusters.get()).getCluster(policy.getClusterName()).getClusterId();
            List<StageEntityPK> requestStageIds = this.findRequestAndStageIdsInClusterBeforeDate(clusterId, policy.getToDateInMillis());
            Set<Long> requestIdsFromUpgrade = this.findAllRequestIdsFromUpgrade();
            Iterator<StageEntityPK> requestStageIdsIterator = requestStageIds.iterator();
            requestIds = new HashSet<Long>();
            while (requestStageIdsIterator.hasNext()) {
                StageEntityPK nextRequestStageIds = requestStageIdsIterator.next();
                if (requestIdsFromUpgrade.contains(nextRequestStageIds.getRequestId())) {
                    requestStageIdsIterator.remove();
                    continue;
                }
                requestIds.add(nextRequestStageIds.getRequestId());
            }
            Set<Long> taskIds = this.hostRoleCommandDAO.findTaskIdsByRequestStageIds(requestStageIds);
            LinkedList<String> params = new LinkedList<String>();
            params.add("stageId");
            params.add("requestId");
            Set<Long> hostTaskIds = this.topologyLogicalTaskDAO.findHostTaskIdsByPhysicalTaskIds(taskIds);
            Set<Long> hostRequestIds = this.topologyHostTaskDAO.findHostRequestIdsByHostTaskIds(hostTaskIds);
            Set<Long> topologyRequestIds = this.topologyLogicalRequestDAO.findRequestIdsByIds(hostRequestIds);
            affectedRows += (long)this.cleanTableByIds(taskIds, "taskIds", "ExecutionCommand", policy.getToDateInMillis(), "ExecutionCommandEntity.removeByTaskIds", ExecutionCommandEntity.class);
            affectedRows += (long)this.cleanTableByIds(taskIds, "taskIds", "TopologyLogicalTask", policy.getToDateInMillis(), "TopologyLogicalTaskEntity.removeByPhysicalTaskIds", TopologyLogicalTaskEntity.class);
            affectedRows += (long)this.cleanTableByIds(hostTaskIds, "hostTaskIds", "TopologyHostTask", policy.getToDateInMillis(), "TopologyHostTaskEntity.removeByTaskIds", TopologyHostTaskEntity.class);
            affectedRows += (long)this.cleanTableByIds(hostRequestIds, "hostRequestIds", "TopologyHostRequest", policy.getToDateInMillis(), "TopologyHostRequestEntity.removeByIds", TopologyHostRequestEntity.class);
            for (Long topologyRequestId : topologyRequestIds) {
                this.topologyRequestDAO.removeByPK(topologyRequestId);
            }
            affectedRows += (long)this.cleanTableByIds(taskIds, "taskIds", "HostRoleCommand", policy.getToDateInMillis(), "HostRoleCommandEntity.removeByTaskIds", HostRoleCommandEntity.class);
            affectedRows += (long)this.cleanTableByStageEntityPK(requestStageIds, params, "RoleSuccessCriteria", policy.getToDateInMillis(), "RoleSuccessCriteriaEntity.removeByRequestStageIds", RoleSuccessCriteriaEntity.class);
            affectedRows += (long)this.cleanTableByStageEntityPK(requestStageIds, params, "Stage", policy.getToDateInMillis(), "StageEntity.removeByRequestStageIds", StageEntity.class);
            affectedRows += (long)this.cleanTableByIds(requestIds, "requestIds", "RequestResourceFilter", policy.getToDateInMillis(), "RequestResourceFilterEntity.removeByRequestIds", RequestResourceFilterEntity.class);
            affectedRows += (long)this.cleanTableByIds(requestIds, "requestIds", "RequestOperationLevel", policy.getToDateInMillis(), "RequestOperationLevelEntity.removeByRequestIds", RequestOperationLevelEntity.class);
        }
        catch (OBDPException e) {
            LOG.error("Error while looking up cluster with name: {}", (Object)policy.getClusterName(), (Object)e);
            throw new IllegalStateException(e);
        }
        return affectedRows += (long)this.cleanTableByIds(requestIds, "requestIds", "Request", policy.getToDateInMillis(), "RequestEntity.removeByRequestIds", RequestEntity.class);
    }

    public static final class StageEntityPK {
        private Long requestId;
        private Long stageId;

        public StageEntityPK(Long requestId, Long stageId) {
            this.requestId = requestId;
            this.stageId = stageId;
        }

        public Long getStageId() {
            return this.stageId;
        }

        public void setStageId(Long stageId) {
            this.stageId = stageId;
        }

        public Long getRequestId() {
            return this.requestId;
        }

        public void setRequestId(Long requestId) {
            this.requestId = requestId;
        }
    }
}

