/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.CrudDAO;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.text.MessageFormat;
import java.util.List;

@Singleton
public class RepositoryVersionDAO
extends CrudDAO<RepositoryVersionEntity, Long> {
    public RepositoryVersionDAO() {
        super(RepositoryVersionEntity.class);
    }

    @Override
    @Transactional
    public void create(RepositoryVersionEntity entity) {
        super.create(entity);
    }

    @RequiresSession
    public RepositoryVersionEntity findByDisplayName(String displayName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionByDisplayName", RepositoryVersionEntity.class);
        query.setParameter("displayname", (Object)displayName);
        return (RepositoryVersionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public RepositoryVersionEntity findByStackAndVersion(StackId stackId, String version) {
        return this.findByStackNameAndVersion(stackId.getStackName(), version);
    }

    @RequiresSession
    public RepositoryVersionEntity findByStackAndVersion(StackEntity stackEntity, String version) {
        return this.findByStackNameAndVersion(stackEntity.getStackName(), version);
    }

    @RequiresSession
    public RepositoryVersionEntity findByStackNameAndVersion(String stackName, String version) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionByStackNameAndVersion", RepositoryVersionEntity.class);
        query.setParameter("stackName", (Object)stackName);
        query.setParameter("version", (Object)version);
        return (RepositoryVersionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<RepositoryVersionEntity> findByStack(StackId stackId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionByStack", RepositoryVersionEntity.class);
        query.setParameter("stackName", (Object)stackId.getStackName());
        query.setParameter("stackVersion", (Object)stackId.getStackVersion());
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<RepositoryVersionEntity> findByStackAndType(StackId stackId, RepositoryType type) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionByStackAndType", RepositoryVersionEntity.class);
        query.setParameter("stackName", (Object)stackId.getStackName());
        query.setParameter("stackVersion", (Object)stackId.getStackVersion());
        query.setParameter("type", (Object)type);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    public RepositoryVersionEntity create(StackEntity stackEntity, String version, String displayName, List<RepoOsEntity> repoOsEntities) throws OBDPException {
        return this.create(stackEntity, version, displayName, repoOsEntities, RepositoryType.STANDARD);
    }

    @Transactional
    public RepositoryVersionEntity create(StackEntity stackEntity, String version, String displayName, List<RepoOsEntity> repoOsEntities, RepositoryType type) throws OBDPException {
        if (stackEntity == null || version == null || version.isEmpty() || displayName == null || displayName.isEmpty()) {
            throw new OBDPException("At least one of the required properties is null or empty");
        }
        RepositoryVersionEntity existingByDisplayName = this.findByDisplayName(displayName);
        if (existingByDisplayName != null) {
            throw new OBDPException("Repository version with display name '" + displayName + "' already exists");
        }
        RepositoryVersionEntity existingVersionInStack = this.findByStackNameAndVersion(stackEntity.getStackName(), version);
        if (existingVersionInStack != null) {
            throw new OBDPException(MessageFormat.format("Repository Version for version {0} already exists, in stack {1}-{2}", version, existingVersionInStack.getStack().getStackName(), existingVersionInStack.getStack().getStackVersion()));
        }
        StackId stackId = new StackId(stackEntity.getStackName(), stackEntity.getStackVersion());
        if (!RepositoryVersionEntity.isVersionInStack(stackId, version)) {
            throw new OBDPException(MessageFormat.format("Version {0} needs to belong to stack {1}", version, stackEntity.getStackName() + "-" + stackEntity.getStackVersion()));
        }
        RepositoryVersionEntity newEntity = new RepositoryVersionEntity(stackEntity, version, displayName, repoOsEntities);
        newEntity.setType(type);
        this.create(newEntity);
        return newEntity;
    }

    @RequiresSession
    public List<RepositoryVersionEntity> findRepositoriesWithVersionDefinitions() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionsFromDefinition", RepositoryVersionEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public RepositoryVersionEntity findByVersion(String repositoryVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("repositoryVersionByVersion", RepositoryVersionEntity.class);
        query.setParameter("version", (Object)repositoryVersion);
        return (RepositoryVersionEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public List<RepositoryVersionEntity> findByServiceDesiredVersion(List<RepositoryVersionEntity> matching) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findByServiceDesiredVersion", RepositoryVersionEntity.class);
        return this.daoUtils.selectList(query, matching);
    }

    @Transactional
    public void removeByStack(StackId stackId) {
        List<RepositoryVersionEntity> repoVersionDeleteCandidates = this.findByStack(stackId);
        for (RepositoryVersionEntity repositoryVersionEntity : repoVersionDeleteCandidates) {
            ((EntityManager)this.entityManagerProvider.get()).remove((Object)repositoryVersionEntity);
        }
    }
}

