/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class RemoteOBDPClusterDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public List<RemoteOBDPClusterEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allRemoteAmbariClusters", RemoteOBDPClusterEntity.class);
        return query.getResultList();
    }

    @RequiresSession
    public RemoteOBDPClusterEntity findByName(String clusterName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("remoteAmbariClusterByName", RemoteOBDPClusterEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        return (RemoteOBDPClusterEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public RemoteOBDPClusterEntity findById(Long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("remoteAmbariClusterById", RemoteOBDPClusterEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return (RemoteOBDPClusterEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public void save(RemoteOBDPClusterEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public void update(RemoteOBDPClusterEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void delete(RemoteOBDPClusterEntity clusterEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)clusterEntity);
    }
}

