/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PrivilegeDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public PrivilegeEntity findById(Integer id) {
        return (PrivilegeEntity)((EntityManager)this.entityManagerProvider.get()).find(PrivilegeEntity.class, (Object)id);
    }

    @RequiresSession
    public List<PrivilegeEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT privilege FROM PrivilegeEntity privilege", PrivilegeEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<PrivilegeEntity> findByResourceId(Long id) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT privilege FROM PrivilegeEntity privilege WHERE privilege.resource.id = :resource_id", PrivilegeEntity.class);
        query.setParameter("resource_id", (Object)id);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    public boolean exists(PrivilegeEntity entity) {
        return this.exists(entity.getPrincipal(), entity.getResource(), entity.getPermission());
    }

    @RequiresSession
    public boolean exists(PrincipalEntity principalEntity, ResourceEntity resourceEntity, PermissionEntity permissionEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT privilege FROM PrivilegeEntity privilege WHERE privilege.principal = :principal AND privilege.resource = :resource AND privilege.permission = :permission", PrivilegeEntity.class);
        query.setParameter("principal", (Object)principalEntity);
        query.setParameter("resource", (Object)resourceEntity);
        query.setParameter("permission", (Object)permissionEntity);
        List privilegeEntities = this.daoUtils.selectList(query, new Object[0]);
        return privilegeEntities != null && !privilegeEntities.isEmpty();
    }

    @RequiresSession
    public List<PrivilegeEntity> findAllByPrincipal(List<PrincipalEntity> principalList) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT privilege FROM PrivilegeEntity privilege WHERE privilege.principal IN :principalList", PrivilegeEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(principalList, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            query.setParameter("principalList", (Object)chunk);
            result.addAll(this.daoUtils.selectList(query, new Object[0]));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @Transactional
    public void create(PrivilegeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public PrivilegeEntity merge(PrivilegeEntity entity) {
        return (PrivilegeEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void remove(PrivilegeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(entity));
    }

    @Transactional
    public void detach(PrivilegeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).detach((Object)entity);
    }
}

