/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class PrincipalTypeDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public PrincipalTypeEntity findById(Integer id) {
        return (PrincipalTypeEntity)((EntityManager)this.entityManagerProvider.get()).find(PrincipalTypeEntity.class, (Object)id);
    }

    @RequiresSession
    public PrincipalTypeEntity findByName(String name) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("PrincipalTypeEntity.findByName", PrincipalTypeEntity.class);
        query.setParameter("name", (Object)name);
        return (PrincipalTypeEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<PrincipalTypeEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT principalType FROM PrincipalTypeEntity principalType", PrincipalTypeEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(PrincipalTypeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public PrincipalTypeEntity merge(PrincipalTypeEntity entity) {
        return (PrincipalTypeEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void remove(PrincipalTypeEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
    }

    @RequiresSession
    public PrincipalTypeEntity ensurePrincipalTypeCreated(int principalType) {
        PrincipalTypeEntity principalTypeEntity = this.findById(principalType);
        if (principalTypeEntity == null) {
            principalTypeEntity = new PrincipalTypeEntity();
            principalTypeEntity.setId(principalType);
            switch (principalType) {
                case 1: {
                    principalTypeEntity.setName(PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME);
                    break;
                }
                case 2: {
                    principalTypeEntity.setName(PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME);
                    break;
                }
                case 8: {
                    principalTypeEntity.setName(PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown principal type ID=" + principalType);
                }
            }
            this.create(principalTypeEntity);
        }
        return principalTypeEntity;
    }
}

