/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Arrays;
import java.util.List;

@Singleton
public class PrincipalDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public PrincipalEntity findById(Long id) {
        return (PrincipalEntity)((EntityManager)this.entityManagerProvider.get()).find(PrincipalEntity.class, (Object)id);
    }

    @RequiresSession
    public List<PrincipalEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT principal FROM PrincipalEntity principal", PrincipalEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<PrincipalEntity> findByPermissionId(Integer id) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("principalByPrivilegeId", PrincipalEntity.class);
        query.setParameter("permission_id", (Object)id);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<PrincipalEntity> findByPrincipalType(String name) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("principalByPrincipalType", PrincipalEntity.class);
        query.setParameter("principal_type", (Object)name);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(PrincipalEntity entity) {
        this.create(Arrays.asList(entity));
    }

    @Transactional
    public void create(List<PrincipalEntity> entities) {
        for (PrincipalEntity entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
        }
    }

    @Transactional
    public PrincipalEntity merge(PrincipalEntity entity) {
        return (PrincipalEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
    }

    @Transactional
    public void remove(PrincipalEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
    }
}

