/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PermissionDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @Transactional
    public void create(PermissionEntity permissionEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)permissionEntity);
    }

    @Transactional
    public PermissionEntity merge(PermissionEntity permissionEntity) {
        return (PermissionEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)permissionEntity);
    }

    @RequiresSession
    public PermissionEntity findById(Integer id) {
        return (PermissionEntity)((EntityManager)this.entityManagerProvider.get()).find(PermissionEntity.class, (Object)id);
    }

    @RequiresSession
    public PermissionEntity findByName(String name) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("PermissionEntity.findByName", PermissionEntity.class);
        query.setParameter("permissionName", (Object)name);
        return (PermissionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<PermissionEntity> findPermissionsByPrincipal(List<PrincipalEntity> principalList) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("PermissionEntity.findByPrincipals", PermissionEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(principalList, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            query.setParameter("principalList", (Object)chunk);
            result.addAll(this.daoUtils.selectList(query, new Object[0]));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<PermissionEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT p FROM PermissionEntity p", PermissionEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public PermissionEntity findPermissionByNameAndType(String name, ResourceTypeEntity resourceType) {
        if (name.equals("VIEW.USER")) {
            return this.findViewUsePermission();
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT p FROM PermissionEntity p WHERE p.permissionName=:permissionname AND p.resourceType=:resourcetype", PermissionEntity.class);
        query.setParameter("permissionname", (Object)name);
        query.setParameter("resourcetype", (Object)resourceType);
        return (PermissionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public PermissionEntity findAmbariAdminPermission() {
        return this.findById(1);
    }

    @RequiresSession
    public PermissionEntity findViewUsePermission() {
        return this.findById(4);
    }

    @RequiresSession
    public PermissionEntity findClusterOperatePermission() {
        return this.findById(3);
    }

    @RequiresSession
    public PermissionEntity findClusterReadPermission() {
        return this.findById(2);
    }
}

