/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.CrudDAO;
import id.onyx.obdp.server.orm.entities.OBDPConfigurationEntity;
import id.onyx.obdp.server.orm.entities.OBDPConfigurationEntityPK;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.TypedQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPConfigurationDAO
extends CrudDAO<OBDPConfigurationEntity, OBDPConfigurationEntityPK> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPConfigurationDAO.class);

    @Inject
    public OBDPConfigurationDAO() {
        super(OBDPConfigurationEntity.class);
    }

    @RequiresSession
    public List<OBDPConfigurationEntity> findByCategory(String categoryName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("OBDPConfigurationEntity.findByCategory", OBDPConfigurationEntity.class);
        query.setParameter("categoryName", (Object)categoryName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public int removeByCategory(String categoryName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("OBDPConfigurationEntity.deleteByCategory", OBDPConfigurationEntity.class);
        query.setParameter("categoryName", (Object)categoryName);
        return query.executeUpdate();
    }

    @Override
    @Transactional
    public void create(OBDPConfigurationEntity entity) {
        OBDPConfigurationEntity foundEntity = (OBDPConfigurationEntity)this.findByPK(new OBDPConfigurationEntityPK(entity.getCategoryName(), entity.getPropertyName()));
        if (foundEntity != null) {
            String message = String.format("Only one configuration entry can exist for the category %s and name %s", entity.getCategoryName(), entity.getPropertyName());
            LOGGER.error(message);
            throw new EntityExistsException(message);
        }
        super.create(entity);
    }

    @Override
    public OBDPConfigurationEntity merge(OBDPConfigurationEntity entity) {
        OBDPConfigurationEntity foundEntity = (OBDPConfigurationEntity)this.findByPK(new OBDPConfigurationEntityPK(entity.getCategoryName(), entity.getPropertyName()));
        if (foundEntity == null) {
            String message = String.format("The configuration entry for the category %s and name %s does not exist", entity.getCategoryName(), entity.getPropertyName());
            LOGGER.debug(message);
            throw new EntityNotFoundException(message);
        }
        OBDPConfigurationEntity updatedEntity = entity;
        if (!StringUtils.equals((String)foundEntity.getPropertyValue(), (String)entity.getPropertyValue())) {
            updatedEntity = super.merge(entity);
            ((EntityManager)this.entityManagerProvider.get()).flush();
        }
        return updatedEntity;
    }

    @Transactional
    public boolean reconcileCategory(String categoryName, Map<String, String> properties, boolean removeIfNotProvided) {
        boolean changesDetected = false;
        List<OBDPConfigurationEntity> existingEntities = this.findByCategory(categoryName);
        HashMap<String, String> propertiesToProcess = new HashMap<String, String>();
        if (properties != null) {
            propertiesToProcess.putAll(properties);
        }
        if (existingEntities != null) {
            for (OBDPConfigurationEntity oBDPConfigurationEntity : existingEntities) {
                String propertyName = oBDPConfigurationEntity.getPropertyName();
                if (propertiesToProcess.containsKey(propertyName)) {
                    String newPropertyValue = (String)propertiesToProcess.get(propertyName);
                    if (!StringUtils.equals((String)newPropertyValue, (String)oBDPConfigurationEntity.getPropertyValue())) {
                        oBDPConfigurationEntity.setPropertyValue(newPropertyValue);
                        this.merge(oBDPConfigurationEntity);
                        changesDetected = true;
                    }
                } else if (removeIfNotProvided) {
                    this.remove(oBDPConfigurationEntity);
                    changesDetected = true;
                }
                propertiesToProcess.remove(propertyName);
            }
        }
        if (!propertiesToProcess.isEmpty()) {
            for (Map.Entry entry : propertiesToProcess.entrySet()) {
                OBDPConfigurationEntity entity = new OBDPConfigurationEntity();
                entity.setCategoryName(categoryName);
                entity.setPropertyName((String)entry.getKey());
                entity.setPropertyValue((String)entry.getValue());
                this.create(entity);
            }
            changesDetected = true;
        }
        if (changesDetected) {
            ((EntityManager)this.entityManagerProvider.get()).flush();
        }
        return changesDetected;
    }
}

