/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.MpackEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MpackDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(MpackDAO.class);
    @Inject
    Provider<EntityManager> m_entityManagerProvider;
    @Inject
    private DaoUtils m_daoUtils;

    @Transactional
    public Long create(MpackEntity mpackEntity) {
        ((EntityManager)this.m_entityManagerProvider.get()).persist((Object)mpackEntity);
        return mpackEntity.getId();
    }

    @RequiresSession
    public MpackEntity findById(long id) {
        return (MpackEntity)((EntityManager)this.m_entityManagerProvider.get()).find(MpackEntity.class, (Object)id);
    }

    @RequiresSession
    public List<MpackEntity> findByNameVersion(String mpackName, String mpackVersion) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("MpackEntity.findByNameVersion", MpackEntity.class);
        query.setParameter("mpackName", (Object)mpackName);
        query.setParameter("mpackVersion", (Object)mpackVersion);
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<MpackEntity> findAll() {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("MpackEntity.findAll", MpackEntity.class);
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void removeById(Long id) {
        ((EntityManager)this.m_entityManagerProvider.get()).remove((Object)this.findById(id));
    }
}

