/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.MetainfoEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;

@Singleton
public class MetainfoDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public MetainfoEntity findByKey(String key) {
        return (MetainfoEntity)((EntityManager)this.entityManagerProvider.get()).find(MetainfoEntity.class, (Object)key);
    }

    @RequiresSession
    public Collection<MetainfoEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT metainfo FROM MetainfoEntity metainfo", MetainfoEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void refresh(MetainfoEntity metainfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)metainfoEntity);
    }

    @Transactional
    public void create(MetainfoEntity metainfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)metainfoEntity);
    }

    @Transactional
    public MetainfoEntity merge(MetainfoEntity metainfoEntity) {
        return (MetainfoEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)metainfoEntity);
    }

    @Transactional
    public void remove(MetainfoEntity metainfoEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(metainfoEntity));
    }

    @Transactional
    public void removeByHostName(String key) {
        this.remove(this.findByKey(key));
    }
}

