/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class MemberDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public MemberEntity findByPK(Integer memberPK) {
        return (MemberEntity)((EntityManager)this.entityManagerProvider.get()).find(MemberEntity.class, (Object)memberPK);
    }

    @RequiresSession
    public MemberEntity findByUserAndGroup(String userName, String groupName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("memberByUserAndGroup", MemberEntity.class);
        query.setParameter("username", (Object)userName.toLowerCase());
        query.setParameter("groupname", (Object)groupName.toLowerCase());
        try {
            return (MemberEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @RequiresSession
    public List<MemberEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT m FROM MemberEntity m", MemberEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<MemberEntity> findAllMembersByUser(UserEntity userEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT m FROM MemberEntity m WHERE m.user = :userEntity", MemberEntity.class);
        query.setParameter("userEntity", (Object)userEntity);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(MemberEntity member) {
        this.create(new HashSet<MemberEntity>(Arrays.asList(member)));
    }

    @Transactional
    public void create(Set<MemberEntity> members) {
        for (MemberEntity member : members) {
            ((EntityManager)this.entityManagerProvider.get()).persist((Object)member);
        }
    }

    @Transactional
    public MemberEntity merge(MemberEntity member) {
        return (MemberEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)member);
    }

    @Transactional
    public void remove(MemberEntity member) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(member));
    }

    @Transactional
    public void remove(Set<MemberEntity> members) {
        for (MemberEntity member : members) {
            ((EntityManager)this.entityManagerProvider.get()).remove(((EntityManager)this.entityManagerProvider.get()).merge((Object)member));
        }
    }

    @Transactional
    public void removeByPK(Integer memberPK) {
        this.remove(this.findByPK(memberPK));
    }
}

