/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.KeyValueEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;

@Singleton
public class KeyValueDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public KeyValueEntity findByKey(String key) {
        return (KeyValueEntity)((EntityManager)this.entityManagerProvider.get()).find(KeyValueEntity.class, (Object)key);
    }

    @RequiresSession
    public Collection<KeyValueEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT keyValue FROM KeyValueEntity keyValue", KeyValueEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void refresh(KeyValueEntity keyValueEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)keyValueEntity);
    }

    @Transactional
    public void create(KeyValueEntity keyValueEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)keyValueEntity);
    }

    @Transactional
    public KeyValueEntity merge(KeyValueEntity keyValueEntity) {
        return (KeyValueEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)keyValueEntity);
    }

    @Transactional
    public void remove(KeyValueEntity keyValueEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(keyValueEntity));
    }

    @Transactional
    public void removeByHostName(String key) {
        this.remove(this.findByKey(key));
    }
}

