/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KerberosPrincipalDAO {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosPrincipalDAO.class);
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @Transactional
    public void create(KerberosPrincipalEntity kerberosPrincipalEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)kerberosPrincipalEntity);
    }

    @Transactional
    public KerberosPrincipalEntity create(String principalName, boolean service) {
        KerberosPrincipalEntity kpe = new KerberosPrincipalEntity(principalName, service, null);
        this.create(kpe);
        return kpe;
    }

    @Transactional
    public KerberosPrincipalEntity merge(KerberosPrincipalEntity kerberosPrincipalEntity) {
        return (KerberosPrincipalEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)kerberosPrincipalEntity);
    }

    @Transactional
    public void remove(KerberosPrincipalEntity kerberosPrincipalEntity) {
        if (kerberosPrincipalEntity != null) {
            EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
            entityManager.remove(entityManager.merge((Object)kerberosPrincipalEntity));
        }
    }

    @Transactional
    public void remove(String principalName) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.find(principalName));
    }

    @Transactional
    public void refresh(KerberosPrincipalEntity kerberosPrincipalEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)kerberosPrincipalEntity);
    }

    @RequiresSession
    public KerberosPrincipalEntity find(String principalName) {
        return (KerberosPrincipalEntity)((EntityManager)this.entityManagerProvider.get()).find(KerberosPrincipalEntity.class, (Object)principalName);
    }

    @RequiresSession
    public List<KerberosPrincipalEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosPrincipalEntityFindAll", KerberosPrincipalEntity.class);
        return query.getResultList();
    }

    @RequiresSession
    public boolean exists(String principalName) {
        return this.find(principalName) != null;
    }

    public void remove(List<KerberosPrincipalEntity> entities) {
        if (entities != null) {
            for (KerberosPrincipalEntity entity : entities) {
                this.remove(entity);
            }
        }
    }

    public boolean removeIfNotReferenced(KerberosPrincipalEntity kerberosPrincipalEntity) {
        if (kerberosPrincipalEntity != null) {
            if (CollectionUtils.isNotEmpty(kerberosPrincipalEntity.getKerberosKeytabPrincipalEntities())) {
                ArrayList<String> ids = new ArrayList<String>();
                for (KerberosKeytabPrincipalEntity entity : kerberosPrincipalEntity.getKerberosKeytabPrincipalEntities()) {
                    Long id = entity.getKkpId();
                    if (id == null) continue;
                    ids.add(String.valueOf(id));
                }
                LOG.info(String.format("principal entry for %s is still referenced by [%s]", kerberosPrincipalEntity.getPrincipalName(), String.join((CharSequence)",", ids)));
            } else {
                LOG.info(String.format("principal entry for %s is no longer referenced. It will be removed.", kerberosPrincipalEntity.getPrincipalName()));
                this.remove(kerberosPrincipalEntity);
                return true;
            }
        }
        return false;
    }
}

