/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;

@Singleton
public class KerberosKeytabPrincipalDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    HostDAO hostDAO;
    @Inject
    DaoUtils daoUtils;

    @Transactional
    public void create(KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)kerberosKeytabPrincipalEntity);
    }

    @Transactional
    public void create(KerberosKeytabEntity kerberosKeytabEntity, HostEntity hostEntity, KerberosPrincipalEntity principalEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)new KerberosKeytabPrincipalEntity(kerberosKeytabEntity, hostEntity, principalEntity));
    }

    public KeytabPrincipalFindOrCreateResult findOrCreate(KerberosKeytabEntity kerberosKeytabEntity, HostEntity hostEntity, KerberosPrincipalEntity kerberosPrincipalEntity, @Nullable List<KerberosKeytabPrincipalEntity> keytabList) {
        KerberosKeytabPrincipalEntity kkp;
        KeytabPrincipalFindOrCreateResult result = new KeytabPrincipalFindOrCreateResult();
        result.created = false;
        Long hostId = hostEntity == null ? null : hostEntity.getHostId();
        KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity = kkp = keytabList == null || keytabList.isEmpty() ? this.findByNaturalKey(hostId, kerberosKeytabEntity.getKeytabPath(), kerberosPrincipalEntity.getPrincipalName()) : (KerberosKeytabPrincipalEntity)keytabList.stream().filter(keytab -> keytab != null && keytab.getHostId() != null && keytab.getKeytabPath() != null && keytab.getPrincipalName() != null && keytab.getHostId().equals(hostId) && keytab.getKeytabPath().equals(kerberosKeytabEntity.getKeytabPath()) && keytab.getPrincipalName().equals(kerberosPrincipalEntity.getPrincipalName())).findFirst().orElse(null);
        if (kkp != null) {
            result.kkp = kkp;
            return result;
        }
        kkp = new KerberosKeytabPrincipalEntity(kerberosKeytabEntity, hostEntity, kerberosPrincipalEntity);
        this.create(kkp);
        kerberosKeytabEntity.addKerberosKeytabPrincipal(kkp);
        kerberosPrincipalEntity.addKerberosKeytabPrincipal(kkp);
        result.kkp = kkp;
        result.created = true;
        return result;
    }

    @Transactional
    public KerberosKeytabPrincipalEntity merge(KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity) {
        return (KerberosKeytabPrincipalEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)kerberosKeytabPrincipalEntity);
    }

    @Transactional
    public void remove(KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(kerberosKeytabPrincipalEntity));
    }

    public void remove(Collection<KerberosKeytabPrincipalEntity> kerberosKeytabPrincipalEntities) {
        for (KerberosKeytabPrincipalEntity entity : kerberosKeytabPrincipalEntities) {
            this.remove(entity);
        }
    }

    @RequiresSession
    public List<KerberosKeytabPrincipalEntity> findByPrincipal(String principal) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findByPrincipal", KerberosKeytabPrincipalEntity.class);
        query.setParameter("principalName", (Object)principal);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<KerberosKeytabPrincipalEntity> findByHost(Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findByHost", KerberosKeytabPrincipalEntity.class);
        query.setParameter("hostId", (Object)hostId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<KerberosKeytabPrincipalEntity> findByHostAndKeytab(Long hostId, String keytabPath) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findByHostAndKeytab", KerberosKeytabPrincipalEntity.class);
        query.setParameter("hostId", (Object)hostId);
        query.setParameter("keytabPath", (Object)keytabPath);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public KerberosKeytabPrincipalEntity findByHostKeytabAndPrincipal(Long hostId, String keytabPath, String principalName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findByHostKeytabAndPrincipal", KerberosKeytabPrincipalEntity.class);
        query.setParameter("hostId", (Object)hostId);
        query.setParameter("keytabPath", (Object)keytabPath);
        query.setParameter("principalName", (Object)principalName);
        return (KerberosKeytabPrincipalEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public KerberosKeytabPrincipalEntity findByKeytabAndPrincipalNullHost(String keytabPath, String principal) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findByKeytabAndPrincipalNullHost", KerberosKeytabPrincipalEntity.class);
        query.setParameter("keytabPath", (Object)keytabPath);
        query.setParameter("principalName", (Object)principal);
        return (KerberosKeytabPrincipalEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    public KerberosKeytabPrincipalEntity findByNaturalKey(Long hostId, String keytabPath, String principalName) {
        if (hostId == null) {
            return this.findByKeytabAndPrincipalNullHost(keytabPath, principalName);
        }
        return this.findByHostKeytabAndPrincipal(hostId, keytabPath, principalName);
    }

    @RequiresSession
    public List<KerberosKeytabPrincipalEntity> findByFilter(KerberosKeytabPrincipalFilter filter) {
        CriteriaBuilder cb = ((EntityManager)this.entityManagerProvider.get()).getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(KerberosKeytabPrincipalEntity.class);
        Root root = cq.from(KerberosKeytabPrincipalEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (CollectionUtils.isNotEmpty(filter.getServiceNames())) {
            Join mappingJoin = root.join("serviceMapping");
            predicates.add(mappingJoin.get("serviceName").in(filter.getServiceNames()));
            if (CollectionUtils.isNotEmpty(filter.getComponentNames())) {
                predicates.add(mappingJoin.get("componentName").in(filter.getComponentNames()));
            }
        }
        if (CollectionUtils.isNotEmpty(filter.getHostNames())) {
            ArrayList<Long> hostIds = new ArrayList<Long>();
            boolean hasNull = false;
            for (String hostname : filter.getHostNames()) {
                HostEntity host = this.hostDAO.findByName(hostname);
                if (host == null) {
                    hasNull = true;
                    continue;
                }
                hostIds.add(host.getHostId());
            }
            if (CollectionUtils.isNotEmpty(hostIds)) {
                ArrayList hostPredicates = new ArrayList();
                SQLOperations.batch(hostIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
                    hostPredicates.add(root.get("hostId").in(chunk));
                    return 0;
                });
                Predicate hostCombinedPredicate = cb.or(hostPredicates.toArray(new Predicate[hostPredicates.size()]));
                predicates.add(hostCombinedPredicate);
            }
            if (hasNull) {
                predicates.add(root.get("hostId").isNull());
            }
        }
        if (CollectionUtils.isNotEmpty(filter.getPrincipals())) {
            ArrayList principalPredicates = new ArrayList();
            SQLOperations.batch(filter.getPrincipals(), 999, (chunk, currentBatch, totalBatches, totalSize) -> {
                principalPredicates.add(root.get("principalName").in(chunk));
                return 0;
            });
            Predicate principalCombinedPredicate = cb.or(principalPredicates.toArray(new Predicate[0]));
            predicates.add(principalCombinedPredicate);
        }
        cq.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(cq);
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public List<KerberosKeytabPrincipalEntity> findByFilters(Collection<KerberosKeytabPrincipalFilter> filters) {
        ArrayList<KerberosKeytabPrincipalEntity> result = new ArrayList<KerberosKeytabPrincipalEntity>();
        for (KerberosKeytabPrincipalFilter filter : filters) {
            result.addAll(this.findByFilter(filter));
        }
        return result;
    }

    @RequiresSession
    public boolean exists(Long hostId, String keytabPath, String principalName) {
        return this.findByNaturalKey(hostId, keytabPath, principalName) != null;
    }

    @RequiresSession
    public List<KerberosKeytabPrincipalEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabPrincipalEntity.findAll", KerberosKeytabPrincipalEntity.class);
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Transactional
    public void remove(List<KerberosKeytabPrincipalEntity> entities) {
        if (entities != null) {
            for (KerberosKeytabPrincipalEntity entity : entities) {
                ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(entity));
            }
        }
    }

    public void removeByHost(Long hostId) {
        this.remove(this.findByHost(hostId));
    }

    public static class KeytabPrincipalFindOrCreateResult {
        public KerberosKeytabPrincipalEntity kkp;
        public boolean created;
    }

    public static class KerberosKeytabPrincipalFilter {
        private Collection<String> hostNames;
        private Collection<String> serviceNames;
        private Collection<String> componentNames;
        private Collection<String> principals;

        private KerberosKeytabPrincipalFilter() {
            this(null, null, null, null);
        }

        private KerberosKeytabPrincipalFilter(Collection<String> hostNames, Collection<String> serviceNames, Collection<String> componentNames, Collection<String> principals) {
            this.hostNames = hostNames;
            this.serviceNames = serviceNames;
            this.componentNames = componentNames;
            this.principals = principals;
        }

        public Collection<String> getHostNames() {
            return this.hostNames;
        }

        public void setHostNames(Collection<String> hostNames) {
            this.hostNames = hostNames;
        }

        public Collection<String> getServiceNames() {
            return this.serviceNames;
        }

        public void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = serviceNames;
        }

        public Collection<String> getComponentNames() {
            return this.componentNames;
        }

        public void setComponentNames(Collection<String> componentNames) {
            this.componentNames = componentNames;
        }

        public Collection<String> getPrincipals() {
            return this.principals;
        }

        public void setPrincipals(Collection<String> principals) {
            this.principals = principals;
        }

        public static KerberosKeytabPrincipalFilter createEmptyFilter() {
            return new KerberosKeytabPrincipalFilter();
        }

        public static KerberosKeytabPrincipalFilter createFilter(String serviceName, Collection<String> componentNames, Collection<String> hostNames, Collection<String> principalNames) {
            return new KerberosKeytabPrincipalFilter(hostNames, serviceName == null ? null : Collections.singleton(serviceName), componentNames, principalNames);
        }
    }
}

