/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KerberosKeytabDAO {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosKeytabDAO.class);
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;

    @Transactional
    public void create(KerberosKeytabEntity kerberosKeytabEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)kerberosKeytabEntity);
    }

    public void create(String keytabPath) {
        this.create(new KerberosKeytabEntity(keytabPath));
    }

    @Transactional
    public KerberosKeytabEntity merge(KerberosKeytabEntity kerberosKeytabEntity) {
        return (KerberosKeytabEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)kerberosKeytabEntity);
    }

    @Transactional
    public void remove(KerberosKeytabEntity kerberosKeytabEntity) {
        if (kerberosKeytabEntity != null) {
            EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
            entityManager.remove(entityManager.merge((Object)kerberosKeytabEntity));
        }
    }

    public void remove(String keytabPath) {
        KerberosKeytabEntity kke = this.find(keytabPath);
        if (kke != null) {
            this.remove(kke);
        }
    }

    @Transactional
    public void refresh(KerberosKeytabEntity kerberosKeytabEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)kerberosKeytabEntity);
    }

    @RequiresSession
    public KerberosKeytabEntity find(String keytabPath) {
        return (KerberosKeytabEntity)((EntityManager)this.entityManagerProvider.get()).find(KerberosKeytabEntity.class, (Object)keytabPath);
    }

    @RequiresSession
    public KerberosKeytabEntity findOrCreate(ResolvedKerberosKeytab resolvedKerberosKeytab) {
        KerberosKeytabEntity result = this.find(resolvedKerberosKeytab.getFile());
        if (result == null) {
            result = new KerberosKeytabEntity(resolvedKerberosKeytab);
            this.create(result);
        }
        return result;
    }

    @RequiresSession
    public List<KerberosKeytabEntity> findByPrincipalAndHost(String principalName, Long hostId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (hostId == null) {
            List<KerberosKeytabEntity> result = this.findByPrincipalAndNullHost(principalName);
            LOG.debug("Loading keytabs by principal name took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return result;
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabEntity.findByPrincipalAndHost", KerberosKeytabEntity.class);
        query.setParameter("hostId", (Object)hostId);
        query.setParameter("principalName", (Object)principalName);
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        LOG.debug("Loading keytabs by principal name and host took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    @RequiresSession
    public List<KerberosKeytabEntity> findByPrincipalAndNullHost(String principalName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabEntity.findByPrincipalAndNullHost", KerberosKeytabEntity.class);
        query.setParameter("principalName", (Object)principalName);
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @RequiresSession
    public List<KerberosKeytabEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("KerberosKeytabEntity.findAll", KerberosKeytabEntity.class);
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @RequiresSession
    public boolean exists(String keytabPath) {
        return this.find(keytabPath) != null;
    }

    @RequiresSession
    public boolean exists(KerberosKeytabEntity kerberosKeytabEntity) {
        return this.find(kerberosKeytabEntity.getKeytabPath()) != null;
    }

    public void remove(List<KerberosKeytabEntity> entities) {
        if (entities != null) {
            for (KerberosKeytabEntity entity : entities) {
                this.remove(entity);
            }
        }
    }

    public boolean removeIfNotReferenced(KerberosKeytabEntity kerberosKeytabEntity) {
        if (kerberosKeytabEntity != null) {
            if (CollectionUtils.isNotEmpty(kerberosKeytabEntity.getKerberosKeytabPrincipalEntities())) {
                ArrayList<String> ids = new ArrayList<String>();
                for (KerberosKeytabPrincipalEntity entity : kerberosKeytabEntity.getKerberosKeytabPrincipalEntities()) {
                    Long id = entity.getKkpId();
                    if (id == null) continue;
                    ids.add(String.valueOf(id));
                }
                LOG.debug(String.format("keytab entry for %s is still referenced by [%s]", kerberosKeytabEntity.getKeytabPath(), String.join((CharSequence)",", ids)));
            } else {
                LOG.debug(String.format("keytab entry for %s is no longer referenced. It will be removed.", kerberosKeytabEntity.getKeytabPath()));
                this.remove(kerberosKeytabEntity);
                return true;
            }
        }
        return false;
    }
}

