/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.KerberosDescriptorEntity;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class KerberosDescriptorDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public KerberosDescriptorEntity findByName(String kerberosDescriptorName) {
        return (KerberosDescriptorEntity)((EntityManager)this.entityManagerProvider.get()).find(KerberosDescriptorEntity.class, (Object)kerberosDescriptorName);
    }

    @RequiresSession
    public List<KerberosDescriptorEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allKerberosDescriptors", KerberosDescriptorEntity.class);
        return query.getResultList();
    }

    @Transactional
    public void create(KerberosDescriptorEntity kerberosDescriptorEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)kerberosDescriptorEntity);
    }

    @Transactional
    public void refresh(KerberosDescriptorEntity kerberosDescriptorEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)kerberosDescriptorEntity);
    }

    @Transactional
    public KerberosDescriptorEntity merge(KerberosDescriptorEntity kerberosDescriptorEntity) {
        return (KerberosDescriptorEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)kerberosDescriptorEntity);
    }

    @Transactional
    public void remove(KerberosDescriptorEntity kerberosDescriptorEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(kerberosDescriptorEntity));
    }

    @Transactional
    public void removeByName(String name) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByName(name));
    }
}

