/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.CrudDAO;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.StackId;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;

@Singleton
public class HostVersionDAO
extends CrudDAO<HostVersionEntity, Long> {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    public HostVersionDAO() {
        super(HostVersionEntity.class);
    }

    @Override
    @Transactional
    public void create(HostVersionEntity entity) throws IllegalArgumentException {
        if (entity.getRepositoryVersion() == null) {
            throw new IllegalArgumentException("RepositoryVersion argument is not set for the entity");
        }
        super.create(entity);
        entity.getRepositoryVersion().updateHostVersionEntityRelation(entity);
    }

    @RequiresSession
    public List<HostVersionEntity> findByClusterStackAndVersion(String clusterName, StackId stackId, String version) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByClusterAndStackAndVersion", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("stackName", (Object)stackId.getStackName());
        query.setParameter("stackVersion", (Object)stackId.getStackVersion());
        query.setParameter("version", (Object)version);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByHost(String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByHostname", HostVersionEntity.class);
        query.setParameter("hostName", (Object)hostName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByClusterAndHost(String clusterName, String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByClusterAndHostname", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("hostName", (Object)hostName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByCluster(String clusterName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findByCluster", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByClusterAndState(String clusterName, RepositoryVersionState state) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findByClusterAndState", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("state", (Object)state);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByClusterHostAndState(String clusterName, String hostName, RepositoryVersionState state) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByClusterHostnameAndState", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("hostName", (Object)hostName);
        query.setParameter("state", (Object)state);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public HostVersionEntity findByClusterStackVersionAndHost(String clusterName, StackId stackId, String version, String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByClusterStackVersionAndHostname", HostVersionEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("stackName", (Object)stackId.getStackName());
        query.setParameter("stackVersion", (Object)stackId.getStackVersion());
        query.setParameter("version", (Object)version);
        query.setParameter("hostName", (Object)hostName);
        return (HostVersionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findHostVersionByClusterAndRepository(long clusterId, RepositoryVersionEntity repositoryVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findHostVersionByClusterAndRepository", HostVersionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("repositoryVersion", (Object)repositoryVersion);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostVersionEntity> findByRepositoryAndStates(RepositoryVersionEntity repositoryVersion, Collection<RepositoryVersionState> states) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("hostVersionByRepositoryAndStates", HostVersionEntity.class);
        query.setParameter("repositoryVersion", (Object)repositoryVersion);
        query.setParameter("states", states);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public HostVersionEntity findHostVersionByHostAndRepository(HostEntity host, RepositoryVersionEntity repositoryVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("findByHostAndRepository", HostVersionEntity.class);
        query.setParameter("host", (Object)host);
        query.setParameter("repositoryVersion", (Object)repositoryVersion);
        return (HostVersionEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void removeByHostName(String hostName) {
        List<HostVersionEntity> hostVersions = this.findByHost(hostName);
        this.remove(hostVersions);
    }
}

