/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.HostStateEntity;
import jakarta.persistence.EntityManager;
import java.util.List;

@Singleton
public class HostStateDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public HostStateEntity findByHostId(Long hostId) {
        return (HostStateEntity)((EntityManager)this.entityManagerProvider.get()).find(HostStateEntity.class, (Object)hostId);
    }

    @RequiresSession
    public List<HostStateEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), HostStateEntity.class);
    }

    @Transactional
    public void refresh(HostStateEntity hostStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)hostStateEntity);
    }

    @Transactional
    public void create(HostStateEntity hostStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)hostStateEntity);
    }

    @Transactional
    public HostStateEntity merge(HostStateEntity hostStateEntity) {
        return (HostStateEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)hostStateEntity);
    }

    @Transactional
    public void remove(HostStateEntity hostStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(hostStateEntity));
    }

    @Transactional
    public void removeByHostId(Long hostId) {
        this.remove(this.findByHostId(hostId));
    }
}

