/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostRoleCommandStatusSummaryDTO {
    private Long m_stageId = 0L;
    private Long m_minTime = 0L;
    private Long m_maxTime = Long.MAX_VALUE;
    private boolean m_skippable = false;
    private Map<HostRoleStatus, Integer> m_counts = new HashMap<HostRoleStatus, Integer>();
    private List<HostRoleStatus> m_tasksStatus = new ArrayList<HostRoleStatus>();

    public HostRoleCommandStatusSummaryDTO(Number skippable, Number minStartTime, Number maxEndTime, Number stageId, Number aborted, Number completed, Number failed, Number holding, Number holdingFailed, Number holdingTimedout, Number inProgress, Number pending, Number queued, Number timedout, Number skippedFailed) {
        this.m_stageId = null == stageId ? 0L : stageId.longValue();
        if (null != skippable) {
            boolean bl = this.m_skippable = 1 == skippable.intValue();
        }
        if (null != minStartTime) {
            this.m_minTime = minStartTime.longValue();
        }
        if (null != maxEndTime) {
            this.m_maxTime = maxEndTime.longValue();
        }
        this.put(HostRoleStatus.ABORTED, aborted);
        this.put(HostRoleStatus.COMPLETED, completed);
        this.put(HostRoleStatus.FAILED, failed);
        this.put(HostRoleStatus.HOLDING, holding);
        this.put(HostRoleStatus.HOLDING_FAILED, holdingFailed);
        this.put(HostRoleStatus.HOLDING_TIMEDOUT, holdingTimedout);
        this.put(HostRoleStatus.IN_PROGRESS, inProgress);
        this.put(HostRoleStatus.PENDING, pending);
        this.put(HostRoleStatus.QUEUED, queued);
        this.put(HostRoleStatus.TIMEDOUT, timedout);
        this.put(HostRoleStatus.SKIPPED_FAILED, skippedFailed);
    }

    private void put(HostRoleStatus status, Number number) {
        if (null != number) {
            this.m_counts.put(status, number.intValue());
            for (int i = 0; i < number.intValue(); ++i) {
                this.m_tasksStatus.add(status);
            }
        } else {
            this.m_counts.put(status, 0);
        }
    }

    Long getStageId() {
        return this.m_stageId;
    }

    public Map<HostRoleStatus, Integer> getCounts() {
        return this.m_counts;
    }

    public List<HostRoleStatus> getTaskStatuses() {
        return this.m_tasksStatus;
    }

    public int getTaskTotal() {
        return this.m_tasksStatus.size();
    }

    public boolean isStageSkippable() {
        return this.m_skippable;
    }

    public Long getStartTime() {
        return this.m_minTime;
    }

    public Long getEndTime() {
        return this.m_maxTime;
    }

    public static HostRoleCommandStatusSummaryDTO create() {
        return new HostRoleCommandStatusSummaryDTO(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public HostRoleCommandStatusSummaryDTO completed(int count) {
        this.put(HostRoleStatus.COMPLETED, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO failed(int count) {
        this.put(HostRoleStatus.FAILED, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO aborted(int count) {
        this.put(HostRoleStatus.ABORTED, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO timedout(int count) {
        this.put(HostRoleStatus.TIMEDOUT, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO inProgress(int count) {
        this.put(HostRoleStatus.IN_PROGRESS, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO pending(int count) {
        this.put(HostRoleStatus.PENDING, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO queued(int count) {
        this.put(HostRoleStatus.QUEUED, count);
        return this;
    }

    public HostRoleCommandStatusSummaryDTO skippedFailed(int count) {
        this.put(HostRoleStatus.SKIPPED_FAILED, count);
        return this;
    }
}

