/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.annotations.TransactionalLock;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.api.query.JpaPredicateVisitor;
import id.onyx.obdp.server.api.query.JpaSortBuilder;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.events.TaskCreateEvent;
import id.onyx.obdp.server.events.TaskUpdateEvent;
import id.onyx.obdp.server.events.publishers.TaskEventPublisher;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.TransactionalLocks;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity_;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HostRoleCommandDAO {
    private static final Logger LOG = LoggerFactory.getLogger(HostRoleCommandDAO.class);
    private static final String SUMMARY_DTO = String.format("SELECT NEW %s(MAX(hrc.stage.skippable), MIN(hrc.startTime), MAX(hrc.endTime), hrc.stageId, SUM(CASE WHEN hrc.status = :aborted THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :completed THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :failed THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :holding THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :holding_failed THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :holding_timedout THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :in_progress THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :pending THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :queued THEN 1 ELSE 0 END), SUM(CASE WHEN hrc.status = :timedout THEN 1 ELSE 0 END),SUM(CASE WHEN hrc.status = :skipped_failed THEN 1 ELSE 0 END)) FROM HostRoleCommandEntity hrc  GROUP BY hrc.requestId, hrc.stageId HAVING hrc.requestId = :requestId", HostRoleCommandStatusSummaryDTO.class.getName());
    private static final String REQUESTS_BY_TASK_STATUS_SQL = "SELECT DISTINCT task.requestId FROM HostRoleCommandEntity task WHERE task.status IN :taskStatuses ORDER BY task.requestId {0}";
    private static final String COMPLETED_REQUESTS_SQL = "SELECT DISTINCT task.requestId FROM HostRoleCommandEntity task WHERE task.requestId NOT IN (SELECT task.requestId FROM HostRoleCommandEntity task WHERE task.status IN :notCompletedStatuses) ORDER BY task.requestId {0}";
    private final Cache<Long, Map<Long, HostRoleCommandStatusSummaryDTO>> hrcStatusSummaryCache;
    private final boolean hostRoleCommandStatusSummaryCacheEnabled;
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;
    @Inject
    private Configuration configuration;
    @Inject
    HostRoleCommandFactory hostRoleCommandFactory;
    @Inject
    private TaskEventPublisher taskEventPublisher;
    @Inject
    private final TransactionalLocks transactionLocks = null;
    public static final String HRC_STATUS_SUMMARY_CACHE_SIZE = "hostRoleCommandStatusSummaryCacheSize";
    public static final String HRC_STATUS_SUMMARY_CACHE_EXPIRY_DURATION_MINUTES = "hostRoleCommandStatusCacheExpiryDurationMins";
    public static final String HRC_STATUS_SUMMARY_CACHE_ENABLED = "hostRoleCommandStatusSummaryCacheEnabled";

    protected void invalidateHostRoleCommandStatusSummaryCache(Long requestId) {
        if (!this.hostRoleCommandStatusSummaryCacheEnabled) {
            return;
        }
        LOG.debug("Invalidating host role command status summary cache for request {} !", (Object)requestId);
        this.hrcStatusSummaryCache.invalidate((Object)requestId);
    }

    protected void invalidateHostRoleCommandStatusSummaryCache(Set<Long> requestIds) {
        for (Long requestId : requestIds) {
            if (null == requestId) continue;
            this.invalidateHostRoleCommandStatusSummaryCache(requestId);
        }
    }

    protected void invalidateHostRoleCommandStatusSummaryCache(HostRoleCommandEntity hostRoleCommandEntity) {
        if (!this.hostRoleCommandStatusSummaryCacheEnabled) {
            return;
        }
        if (hostRoleCommandEntity != null) {
            StageEntity stageEntity;
            Long requestId = hostRoleCommandEntity.getRequestId();
            if (requestId == null && (stageEntity = hostRoleCommandEntity.getStage()) != null) {
                requestId = stageEntity.getRequestId();
            }
            if (requestId != null) {
                this.invalidateHostRoleCommandStatusSummaryCache((long)requestId);
            }
        }
    }

    @RequiresSession
    private Map<Long, HostRoleCommandStatusSummaryDTO> loadAggregateCounts(Long requestId) {
        HashMap<Long, HostRoleCommandStatusSummaryDTO> map = new HashMap<Long, HostRoleCommandStatusSummaryDTO>();
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createQuery(SUMMARY_DTO, HostRoleCommandStatusSummaryDTO.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("aborted", (Object)HostRoleStatus.ABORTED);
        query.setParameter("completed", (Object)HostRoleStatus.COMPLETED);
        query.setParameter("failed", (Object)HostRoleStatus.FAILED);
        query.setParameter("holding", (Object)HostRoleStatus.HOLDING);
        query.setParameter("holding_failed", (Object)HostRoleStatus.HOLDING_FAILED);
        query.setParameter("holding_timedout", (Object)HostRoleStatus.HOLDING_TIMEDOUT);
        query.setParameter("in_progress", (Object)HostRoleStatus.IN_PROGRESS);
        query.setParameter("pending", (Object)HostRoleStatus.PENDING);
        query.setParameter("queued", (Object)HostRoleStatus.QUEUED);
        query.setParameter("timedout", (Object)HostRoleStatus.TIMEDOUT);
        query.setParameter("skipped_failed", (Object)HostRoleStatus.SKIPPED_FAILED);
        for (HostRoleCommandStatusSummaryDTO dto : this.daoUtils.selectList(query, new Object[0])) {
            map.put(dto.getStageId(), dto);
        }
        return map;
    }

    @Inject
    public HostRoleCommandDAO(@Named(value="hostRoleCommandStatusSummaryCacheEnabled") boolean hostRoleCommandStatusSummaryCacheEnabled, @Named(value="hostRoleCommandStatusSummaryCacheSize") long hostRoleCommandStatusSummaryCacheLimit, @Named(value="hostRoleCommandStatusCacheExpiryDurationMins") long hostRoleCommandStatusSummaryCacheExpiryDurationMins) {
        this.hostRoleCommandStatusSummaryCacheEnabled = hostRoleCommandStatusSummaryCacheEnabled;
        LOG.info("Host role command status summary cache {} !", (Object)(hostRoleCommandStatusSummaryCacheEnabled ? "enabled" : "disabled"));
        this.hrcStatusSummaryCache = CacheBuilder.newBuilder().maximumSize(hostRoleCommandStatusSummaryCacheLimit).expireAfterWrite(hostRoleCommandStatusSummaryCacheExpiryDurationMins, TimeUnit.MINUTES).build();
    }

    @RequiresSession
    public HostRoleCommandEntity findByPK(long taskId) {
        return (HostRoleCommandEntity)((EntityManager)this.entityManagerProvider.get()).find(HostRoleCommandEntity.class, (Object)taskId);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByPKs(Collection<Long> taskIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT task FROM HostRoleCommandEntity task WHERE task.taskId IN ?1 ORDER BY task.taskId", HostRoleCommandEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(taskIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            result.addAll(this.daoUtils.selectList(query, chunk));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findStatusRolesByPKs(Collection<Long> taskIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT task.taskId, task.status, task.role FROM HostRoleCommandEntity task WHERE task.taskId IN ?1 ORDER BY task.taskId", Object[].class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(taskIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            List queryResult = this.daoUtils.selectList(query, chunk);
            result.addAll(queryResult.stream().map(o -> {
                HostRoleCommandEntity e = new HostRoleCommandEntity();
                e.setTaskId((Long)o[0]);
                e.setStatus(HostRoleStatus.valueOf(o[1].toString()));
                e.setRole(Role.valueOf(o[2].toString()));
                return e;
            }).collect(Collectors.toList()));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByHostId(Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findByHostId", HostRoleCommandEntity.class);
        query.setParameter("hostId", (Object)hostId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByRequestIds(Collection<Long> requestIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT task FROM HostRoleCommandEntity task WHERE task.requestId IN ?1 ORDER BY task.taskId", HostRoleCommandEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(requestIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            result.addAll(this.daoUtils.selectList(query, chunk));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByRequestIdAndStatuses(Long requestId, Collection<HostRoleStatus> statuses) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findByRequestIdAndStatuses", HostRoleCommandEntity.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("statuses", statuses);
        List results = query.getResultList();
        return results;
    }

    @RequiresSession
    public List<Long> findTaskIdsByRequestIds(Collection<Long> requestIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT task.taskId FROM HostRoleCommandEntity task WHERE task.requestId IN ?1 ORDER BY task.taskId", Long.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(requestIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            result.addAll(this.daoUtils.selectList(query, chunk));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByRequestAndTaskIds(Collection<Long> requestIds, Collection<Long> taskIds) {
        if (CollectionUtils.isEmpty(requestIds) || CollectionUtils.isEmpty(taskIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT DISTINCT task FROM HostRoleCommandEntity task WHERE task.requestId IN ?1 AND task.taskId IN ?2 ORDER BY task.taskId", HostRoleCommandEntity.class);
        return this.runQueryForVastRequestsAndTaskIds(query, requestIds, taskIds);
    }

    @RequiresSession
    public List<Long> findTaskIdsByRequestAndTaskIds(Collection<Long> requestIds, Collection<Long> taskIds) {
        if (CollectionUtils.isEmpty(requestIds) || CollectionUtils.isEmpty(taskIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT DISTINCT task.taskId FROM HostRoleCommandEntity task WHERE task.requestId IN ?1 AND task.taskId IN ?2 ORDER BY task.taskId", Long.class);
        return this.runQueryForVastRequestsAndTaskIds(query, requestIds, taskIds);
    }

    private <T> List<T> runQueryForVastRequestsAndTaskIds(TypedQuery<T> query, Collection<Long> requestIds, Collection<Long> taskIds) {
        int batchSize = 999;
        ArrayList result = new ArrayList();
        SQLOperations.batch(taskIds, 999, (taskChunk, currentTaskBatch, totalTaskBatches, totalTaskSize) -> {
            SQLOperations.batch(requestIds, 999, (requestChunk, currentRequestBatch, totalRequestBatches, totalRequestSize) -> {
                result.addAll(this.daoUtils.selectList(query, requestChunk, taskChunk));
                return 0;
            });
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public List<Long> findTaskIdsByHostRoleAndStatus(String hostname, String role, HostRoleStatus status) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT DISTINCT task.taskId FROM HostRoleCommandEntity task WHERE task.hostEntity.hostName=?1 AND task.role=?2 AND task.status=?3 ORDER BY task.taskId", Long.class);
        return this.daoUtils.selectList(query, new Object[]{hostname, role, status});
    }

    @RequiresSession
    public List<Long> findTaskIdsByRoleAndStatus(String role, HostRoleStatus status) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT DISTINCT task.taskId FROM HostRoleCommandEntity task WHERE task.role=?1 AND task.status=?2 ORDER BY task.taskId", Long.class);
        return this.daoUtils.selectList(query, new Object[]{role, status});
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findSortedCommandsByRequestIdAndCustomCommandName(Long requestId, String customCommandName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostRoleCommand FROM HostRoleCommandEntity hostRoleCommand WHERE hostRoleCommand.requestId=?1 AND hostRoleCommand.customCommandName=?2 ORDER BY hostRoleCommand.taskId", HostRoleCommandEntity.class);
        return this.daoUtils.selectList(query, requestId, customCommandName);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findSortedCommandsByStageAndHost(StageEntity stageEntity, HostEntity hostEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostRoleCommand FROM HostRoleCommandEntity hostRoleCommand WHERE hostRoleCommand.stage=?1 AND hostRoleCommand.hostEntity.hostName=?2 ORDER BY hostRoleCommand.taskId", HostRoleCommandEntity.class);
        return this.daoUtils.selectList(query, stageEntity, hostEntity.getHostName());
    }

    @RequiresSession
    public Map<String, List<HostRoleCommandEntity>> findSortedCommandsByStage(StageEntity stageEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostRoleCommand FROM HostRoleCommandEntity hostRoleCommand WHERE hostRoleCommand.stage=?1 ORDER BY hostRoleCommand.hostEntity.hostName, hostRoleCommand.taskId", HostRoleCommandEntity.class);
        List commandEntities = this.daoUtils.selectList(query, stageEntity);
        HashMap<String, List<HostRoleCommandEntity>> hostCommands = new HashMap<String, List<HostRoleCommandEntity>>();
        for (HostRoleCommandEntity commandEntity : commandEntities) {
            if (!hostCommands.containsKey(commandEntity.getHostName())) {
                hostCommands.put(commandEntity.getHostName(), new ArrayList());
            }
            ((List)hostCommands.get(commandEntity.getHostName())).add(commandEntity);
        }
        return hostCommands;
    }

    @RequiresSession
    public List<Long> findTaskIdsByStage(long requestId, long stageId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT hostRoleCommand.taskId FROM HostRoleCommandEntity hostRoleCommand WHERE hostRoleCommand.stage.requestId=?1 AND hostRoleCommand.stage.stageId=?2 ORDER BY hostRoleCommand.taskId", Long.class);
        return this.daoUtils.selectList(query, requestId, stageId);
    }

    @RequiresSession
    public Map<Long, Integer> getHostIdToCountOfCommandsWithStatus(Collection<HostRoleStatus> statuses) {
        HashMap<Long, Integer> hostIdToCount = new HashMap<Long, Integer>();
        String queryName = "SELECT command.hostId FROM HostRoleCommandEntity command WHERE command.status IN :statuses";
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(queryName, Long.class);
        query.setParameter("statuses", statuses);
        List results = query.getResultList();
        for (Long hostId : results) {
            if (hostIdToCount.containsKey(hostId)) {
                hostIdToCount.put(hostId, (Integer)hostIdToCount.get(hostId) + 1);
                continue;
            }
            hostIdToCount.put(hostId, 1);
        }
        return hostIdToCount;
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByHostRole(String hostName, long requestId, long stageId, String role) {
        String queryName = null == hostName ? "HostRoleCommandEntity.findByHostRoleNullHost" : "HostRoleCommandEntity.findByHostRole";
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery(queryName, HostRoleCommandEntity.class);
        if (null != hostName) {
            query.setParameter("hostName", (Object)hostName);
        }
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("stageId", (Object)stageId);
        query.setParameter("role", (Object)role);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByRequest(long requestId) {
        return this.findByRequest(requestId, false);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByRequest(long requestId, boolean refreshHint) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findByRequestId", HostRoleCommandEntity.class);
        if (refreshHint) {
            query.setHint("eclipselink.refresh", (Object)"True");
        }
        query.setParameter("requestId", (Object)requestId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<Long> findTaskIdsByRequest(long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT command.taskId FROM HostRoleCommandEntity command WHERE command.requestId=?1 ORDER BY command.taskId", Long.class);
        return this.daoUtils.selectList(query, requestId);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByStatus(Collection<HostRoleStatus> statuses) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findByCommandStatuses", HostRoleCommandEntity.class);
        query.setParameter("statuses", statuses);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public Number getCountByStatus(Collection<HostRoleStatus> statuses) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findCountByCommandStatuses", Number.class);
        query.setParameter("statuses", statuses);
        return (Number)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), HostRoleCommandEntity.class);
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findByStatusBetweenStages(long requestId, HostRoleStatus status, long minStageId, long maxStageId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findByStatusBetweenStages", HostRoleCommandEntity.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("status", (Object)status);
        query.setParameter("minStageId", (Object)minStageId);
        query.setParameter("maxStageId", (Object)maxStageId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<Long> getRequestsByTaskStatus(Collection<HostRoleStatus> statuses, int maxResults, boolean ascOrder) {
        String sortOrder = "ASC";
        if (!ascOrder) {
            sortOrder = "DESC";
        }
        String sql = MessageFormat.format(REQUESTS_BY_TASK_STATUS_SQL, sortOrder);
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(sql, Long.class);
        query.setParameter("taskStatuses", statuses);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<Long> getCompletedRequests(int maxResults, boolean ascOrder) {
        String sortOrder = "ASC";
        if (!ascOrder) {
            sortOrder = "DESC";
        }
        String sql = MessageFormat.format(COMPLETED_REQUESTS_SQL, sortOrder);
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(sql, Long.class);
        query.setParameter("notCompletedStatuses", HostRoleStatus.NOT_COMPLETED_STATUSES);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public int updateStatusByRequestId(long requestId, HostRoleStatus target, Collection<HostRoleStatus> sources) {
        TypedQuery selectQuery = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT command FROM HostRoleCommandEntity command WHERE command.requestId=?1 AND command.status IN ?2", HostRoleCommandEntity.class);
        List commandEntities = this.daoUtils.selectList(selectQuery, requestId, sources);
        for (HostRoleCommandEntity entity : commandEntities) {
            entity.setStatus(target);
            this.merge(entity);
        }
        return commandEntities.size();
    }

    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public void create(HostRoleCommandEntity entity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)entity);
        this.invalidateHostRoleCommandStatusSummaryCache(entity);
    }

    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public HostRoleCommandEntity merge(HostRoleCommandEntity entity) {
        entity = this.mergeWithoutPublishEvent(entity);
        this.publishTaskUpdateEvent(Collections.singletonList(this.hostRoleCommandFactory.createExisting(entity)));
        return entity;
    }

    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public HostRoleCommandEntity mergeWithoutPublishEvent(HostRoleCommandEntity entity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entity = (HostRoleCommandEntity)entityManager.merge((Object)entity);
        this.invalidateHostRoleCommandStatusSummaryCache(entity);
        return entity;
    }

    @Transactional
    public void removeByHostId(Long hostId) {
        List<HostRoleCommandEntity> commands = this.findByHostId(hostId);
        for (HostRoleCommandEntity cmd : commands) {
            this.remove(cmd);
        }
    }

    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public List<HostRoleCommandEntity> mergeAll(Collection<HostRoleCommandEntity> entities) {
        LinkedHashSet<Long> requestsToInvalidate = new LinkedHashSet<Long>();
        ArrayList<HostRoleCommandEntity> managedList = new ArrayList<HostRoleCommandEntity>(entities.size());
        for (HostRoleCommandEntity entity : entities) {
            StageEntity stageEntity;
            EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
            entity = (HostRoleCommandEntity)entityManager.merge((Object)entity);
            managedList.add(entity);
            Long requestId = entity.getRequestId();
            if (requestId == null && (stageEntity = entity.getStage()) != null) {
                requestId = stageEntity.getRequestId();
            }
            requestsToInvalidate.add(requestId);
        }
        this.invalidateHostRoleCommandStatusSummaryCache(requestsToInvalidate);
        this.publishTaskUpdateEvent(this.getHostRoleCommands(entities));
        return managedList;
    }

    public List<HostRoleCommand> getHostRoleCommands(Collection<HostRoleCommandEntity> entities) {
        Function<HostRoleCommandEntity, HostRoleCommand> transform = new Function<HostRoleCommandEntity, HostRoleCommand>(){

            public HostRoleCommand apply(HostRoleCommandEntity entity) {
                return HostRoleCommandDAO.this.hostRoleCommandFactory.createExisting(entity);
            }
        };
        return FluentIterable.from(entities).transform((Function)transform).toList();
    }

    public void publishTaskUpdateEvent(List<HostRoleCommand> hostRoleCommands) {
        if (!hostRoleCommands.isEmpty()) {
            TaskUpdateEvent taskUpdateEvent = new TaskUpdateEvent(hostRoleCommands);
            this.taskEventPublisher.publish(taskUpdateEvent);
        }
    }

    public void publishTaskCreateEvent(List<HostRoleCommand> hostRoleCommands) {
        if (!hostRoleCommands.isEmpty()) {
            TaskCreateEvent taskCreateEvent = new TaskCreateEvent(hostRoleCommands);
            this.taskEventPublisher.publish(taskCreateEvent);
        }
    }

    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public void remove(HostRoleCommandEntity entity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.remove((Object)entity);
        this.invalidateHostRoleCommandStatusSummaryCache(entity);
    }

    @Transactional
    public void removeByPK(int taskId) {
        this.remove(this.findByPK(taskId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresSession
    public Map<Long, HostRoleCommandStatusSummaryDTO> findAggregateCounts(Long requestId) {
        if (!this.hostRoleCommandStatusSummaryCacheEnabled) {
            return this.loadAggregateCounts(requestId);
        }
        Map<Long, HostRoleCommandStatusSummaryDTO> map = (Map<Long, HostRoleCommandStatusSummaryDTO>)this.hrcStatusSummaryCache.getIfPresent((Object)requestId);
        if (null != map) {
            return map;
        }
        ReadWriteLock lock = this.transactionLocks.getLock(TransactionalLock.LockArea.HRC_STATUS_CACHE);
        lock.readLock().lock();
        try {
            map = this.loadAggregateCounts(requestId);
            this.hrcStatusSummaryCache.put((Object)requestId, map);
            Map<Long, HostRoleCommandStatusSummaryDTO> map2 = map;
            return map2;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @RequiresSession
    public HostRoleCommandEntity findMostRecentFailure(Long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findTasksByStatusesOrderByIdDesc", HostRoleCommandEntity.class);
        query.setParameter("requestId", (Object)requestId);
        query.setParameter("statuses", HostRoleStatus.STACK_UPGRADE_FAILED_STATUSES);
        List results = query.getResultList();
        if (!results.isEmpty()) {
            HostRoleCommandEntity candidate = (HostRoleCommandEntity)results.get(0);
            TypedQuery numberAlreadyRanTasksInFutureStage = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findNumTasksAlreadyRanInStage", Number.class);
            numberAlreadyRanTasksInFutureStage.setParameter("requestId", (Object)requestId);
            numberAlreadyRanTasksInFutureStage.setParameter("taskId", (Object)candidate.getTaskId());
            numberAlreadyRanTasksInFutureStage.setParameter("stageId", (Object)candidate.getStageId());
            numberAlreadyRanTasksInFutureStage.setParameter("statuses", HostRoleStatus.SCHEDULED_STATES);
            Number result = (Number)this.daoUtils.selectSingle(numberAlreadyRanTasksInFutureStage, new Object[0]);
            if (result.longValue() == 0L) {
                return candidate;
            }
        }
        return null;
    }

    @Transactional
    public void updateAutomaticSkipOnFailure(long requestId, boolean skipOnFailure, boolean skipOnServiceCheckFailure) {
        List<HostRoleCommandEntity> tasks = this.findByRequest(requestId);
        for (HostRoleCommandEntity task : tasks) {
            StageEntity stage = task.getStage();
            boolean isStageSkippable = stage.isSkippable();
            boolean isAutoSkipSupportedOnStage = stage.isAutoSkipOnFailureSupported();
            if (!isStageSkippable || !isAutoSkipSupportedOnStage) {
                task.setAutoSkipOnFailure(false);
            } else if (task.getRoleCommand() == RoleCommand.SERVICE_CHECK) {
                task.setAutoSkipOnFailure(skipOnServiceCheckFailure);
            } else {
                task.setAutoSkipOnFailure(skipOnFailure);
            }
            this.merge(task);
        }
    }

    @RequiresSession
    public List<HostRoleCommandEntity> findAll(Request request, id.onyx.obdp.server.controller.spi.Predicate predicate) {
        SortRequest sortRequest;
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        HostRoleCommandPredicateVisitor visitor = new HostRoleCommandPredicateVisitor();
        PredicateHelper.visit(predicate, visitor);
        CriteriaQuery query = visitor.getCriteriaQuery();
        Predicate jpaPredicate = visitor.getJpaPredicate();
        if (null != jpaPredicate) {
            query.where((Expression)jpaPredicate);
        }
        if (null != (sortRequest = request.getSortRequest())) {
            JpaSortBuilder<HostRoleCommandEntity> sortBuilder = new JpaSortBuilder<HostRoleCommandEntity>();
            List<Order> sortOrders = sortBuilder.buildSortOrders(sortRequest, visitor);
            query.orderBy(sortOrders);
        }
        TypedQuery typedQuery = entityManager.createQuery(query);
        PageRequest pagination = request.getPageRequest();
        if (null != pagination) {
            typedQuery.setFirstResult(pagination.getOffset());
            typedQuery.setMaxResults(pagination.getPageSize());
        }
        return this.daoUtils.selectList(typedQuery, new Object[0]);
    }

    @RequiresSession
    public List<String> getHostsWithPendingTasks(long iLowestRequestIdInProgress, long iHighestRequestIdInProgress) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findHostsByCommandStatus", String.class);
        query.setParameter("iLowestRequestIdInProgress", (Object)iLowestRequestIdInProgress);
        query.setParameter("iHighestRequestIdInProgress", (Object)iHighestRequestIdInProgress);
        query.setParameter("statuses", HostRoleStatus.IN_PROGRESS_STATUSES);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<String> getBlockingHostsForRequest(long lowerRequestIdInclusive, long requestId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.getBlockingHostsForRequest", String.class);
        query.setParameter("lowerRequestIdInclusive", (Object)lowerRequestIdInclusive);
        query.setParameter("upperRequestIdExclusive", (Object)requestId);
        query.setParameter("statuses", HostRoleStatus.IN_PROGRESS_STATUSES);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<LastServiceCheckDTO> getLatestServiceChecksByRole(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostRoleCommandEntity.findLatestServiceChecksByRole", LastServiceCheckDTO.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("roleCommand", (Object)RoleCommand.SERVICE_CHECK);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    public Set<Long> findTaskIdsByRequestStageIds(List<RequestDAO.StageEntityPK> requestStageIds) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        ArrayList taskIds = new ArrayList();
        for (RequestDAO.StageEntityPK requestIds : requestStageIds) {
            TypedQuery hostRoleCommandQuery = entityManager.createNamedQuery("HostRoleCommandEntity.findTaskIdsByRequestStageIds", Long.class);
            hostRoleCommandQuery.setParameter("requestId", (Object)requestIds.getRequestId());
            hostRoleCommandQuery.setParameter("stageId", (Object)requestIds.getStageId());
            taskIds.addAll(this.daoUtils.selectList(hostRoleCommandQuery, new Object[0]));
        }
        return Sets.newHashSet(taskIds);
    }

    private final class HostRoleCommandPredicateVisitor
    extends JpaPredicateVisitor<HostRoleCommandEntity> {
        public HostRoleCommandPredicateVisitor() {
            super((EntityManager)HostRoleCommandDAO.this.entityManagerProvider.get(), HostRoleCommandEntity.class);
        }

        @Override
        public Class<HostRoleCommandEntity> getEntityClass() {
            return HostRoleCommandEntity.class;
        }

        @Override
        public List<? extends SingularAttribute<?, ?>> getPredicateMapping(String propertyId) {
            return HostRoleCommandEntity_.getPredicateMapping().get(propertyId);
        }
    }

    public static class LastServiceCheckDTO {
        public final String role;
        public final long endTime;

        public LastServiceCheckDTO(String role, long endTime) {
            this.role = role;
            this.endTime = endTime;
        }
    }
}

