/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class HostDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public HostEntity findById(long hostId) {
        return (HostEntity)((EntityManager)this.entityManagerProvider.get()).find(HostEntity.class, (Object)hostId);
    }

    @RequiresSession
    public HostEntity findByName(String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostEntity.findByHostName", HostEntity.class);
        query.setParameter("hostName", (Object)hostName);
        try {
            return (HostEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<HostEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT host FROM HostEntity host", HostEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    @RequiresSession
    public List<HostEntity> findByStage(StageEntity stageEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT host FROM HostEntity host WHERE host.hostName IN (SELECT DISTINCT host.hostName FROM HostEntity host JOIN host.hostRoleCommandEntities command JOIN command.stage stage WHERE stage=:stageEntity)", HostEntity.class);
        query.setParameter("stageEntity", (Object)stageEntity);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    @Transactional
    public void refresh(HostEntity hostEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)hostEntity);
    }

    @Transactional
    public void create(HostEntity hostEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)hostEntity);
    }

    @Transactional
    public HostEntity merge(HostEntity hostEntity) {
        return (HostEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)hostEntity);
    }

    @Transactional
    public void remove(HostEntity hostEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)hostEntity);
    }

    public List<String> getHostNamesByHostIds(List<Long> hostIds) {
        ArrayList<String> hostNames = new ArrayList<String>();
        if (hostIds != null) {
            for (Long hostId : hostIds) {
                HostEntity hostEntity = this.findById(hostId);
                hostNames.add(hostEntity.getHostName());
            }
        }
        return hostNames;
    }
}

