/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.cache.HostConfigMapping;
import id.onyx.obdp.server.orm.cache.HostConfigMappingImpl;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostConfigMappingEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

@Singleton
public class HostConfigMappingDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;
    @Inject
    private HostDAO hostDAO;
    private ConcurrentHashMap<Long, Set<HostConfigMapping>> hostConfigMappingByHost;
    private volatile boolean cacheLoaded;

    private void populateCache() {
        if (!this.cacheLoaded) {
            if (this.hostConfigMappingByHost == null) {
                this.hostConfigMappingByHost = new ConcurrentHashMap();
                TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostConfigMappingEntity.findAll", HostConfigMappingEntity.class);
                List hostConfigMappingEntities = this.daoUtils.selectList(query, new Object[0]);
                for (HostConfigMappingEntity hostConfigMappingEntity : hostConfigMappingEntities) {
                    Set<Object> setByHost;
                    Long hostId = hostConfigMappingEntity.getHostId();
                    if (hostId == null) continue;
                    if (this.hostConfigMappingByHost.containsKey(hostId)) {
                        setByHost = this.hostConfigMappingByHost.get(hostId);
                    } else {
                        setByHost = new HashSet();
                        this.hostConfigMappingByHost.put(hostId, setByHost);
                    }
                    HostConfigMapping hostConfigMapping = this.buildHostConfigMapping(hostConfigMappingEntity);
                    setByHost.add(hostConfigMapping);
                }
            }
            this.cacheLoaded = true;
        }
    }

    @Transactional
    public void create(HostConfigMapping hostConfigMapping) {
        this.populateCache();
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)this.buildHostConfigMappingEntity(hostConfigMapping));
        Long hostId = hostConfigMapping.getHostId();
        if (hostId != null) {
            Set<Object> set;
            if (this.hostConfigMappingByHost.containsKey(hostId)) {
                set = this.hostConfigMappingByHost.get(hostId);
            } else {
                set = new HashSet();
                this.hostConfigMappingByHost.put(hostId, set);
            }
            set.add(hostConfigMapping);
        }
    }

    @Transactional
    public HostConfigMapping merge(HostConfigMapping hostConfigMapping) {
        this.populateCache();
        Long hostId = hostConfigMapping.getHostId();
        if (hostId != null) {
            Set<Object> set;
            if (this.hostConfigMappingByHost.containsKey(hostId)) {
                set = this.hostConfigMappingByHost.get(hostId);
            } else {
                set = new HashSet();
                this.hostConfigMappingByHost.put(hostId, set);
            }
            set.remove(hostConfigMapping);
            set.add(hostConfigMapping);
            ((EntityManager)this.entityManagerProvider.get()).merge((Object)this.buildHostConfigMappingEntity(hostConfigMapping));
        }
        return hostConfigMapping;
    }

    @RequiresSession
    public Set<HostConfigMapping> findByType(final long clusterId, Long hostId, final String type) {
        this.populateCache();
        if (!this.hostConfigMappingByHost.containsKey(hostId)) {
            return Collections.emptySet();
        }
        HashSet<HostConfigMapping> set = new HashSet<HostConfigMapping>((Collection)this.hostConfigMappingByHost.get(hostId));
        CollectionUtils.filter(set, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((HostConfigMapping)arg0).getClusterId().equals(clusterId) && ((HostConfigMapping)arg0).getType().equals(type);
            }
        });
        return set;
    }

    @RequiresSession
    public HostConfigMapping findSelectedByType(final long clusterId, Long hostId, final String type) {
        this.populateCache();
        if (!this.hostConfigMappingByHost.containsKey(hostId)) {
            return null;
        }
        HashSet set = new HashSet(this.hostConfigMappingByHost.get(hostId));
        HostConfigMapping result = (HostConfigMapping)CollectionUtils.find(set, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((HostConfigMapping)arg0).getClusterId().equals(clusterId) && ((HostConfigMapping)arg0).getType().equals(type) && ((HostConfigMapping)arg0).getSelected() > 0;
            }
        });
        return result;
    }

    @RequiresSession
    public Set<HostConfigMapping> findSelected(final long clusterId, Long hostId) {
        this.populateCache();
        if (!this.hostConfigMappingByHost.containsKey(hostId)) {
            return Collections.emptySet();
        }
        HashSet<HostConfigMapping> set = new HashSet<HostConfigMapping>((Collection)this.hostConfigMappingByHost.get(hostId));
        CollectionUtils.filter(set, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((HostConfigMapping)arg0).getClusterId().equals(clusterId) && ((HostConfigMapping)arg0).getSelected() > 0;
            }
        });
        return set;
    }

    @RequiresSession
    public Set<HostConfigMapping> findSelectedByHosts(Collection<Long> hostIds) {
        this.populateCache();
        if (hostIds == null || hostIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<HostConfigMapping> result = new HashSet<HostConfigMapping>();
        for (final Long hostId : hostIds) {
            if (!this.hostConfigMappingByHost.containsKey(hostId)) continue;
            HashSet set = new HashSet(this.hostConfigMappingByHost.get(hostId));
            CollectionUtils.filter(set, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return ((HostConfigMapping)arg0).getHostId().equals(hostId) && ((HostConfigMapping)arg0).getSelected() > 0;
                }
            });
            result.addAll(set);
        }
        return result;
    }

    @RequiresSession
    public Map<String, List<HostConfigMapping>> findSelectedHostsByTypes(long clusterId, Collection<String> types) {
        this.populateCache();
        HashMap<String, List<HostConfigMapping>> mappingsByType = new HashMap<String, List<HostConfigMapping>>();
        for (String type : types) {
            if (mappingsByType.containsKey(type)) continue;
            mappingsByType.put(type, new ArrayList());
        }
        if (!types.isEmpty()) {
            ArrayList<HostConfigMappingImpl> mappings = new ArrayList<HostConfigMappingImpl>();
            for (Set<HostConfigMapping> set : this.hostConfigMappingByHost.values()) {
                for (HostConfigMapping entry : set) {
                    if (!types.contains(entry.getType()) || !entry.getClusterId().equals(clusterId)) continue;
                    mappings.add(new HostConfigMappingImpl(entry));
                }
            }
            for (HostConfigMapping hostConfigMapping : mappings) {
                ((List)mappingsByType.get(hostConfigMapping.getType())).add(hostConfigMapping);
            }
        }
        return mappingsByType;
    }

    @RequiresSession
    public List<HostConfigMappingEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), HostConfigMappingEntity.class);
    }

    @Transactional
    public void removeByHostId(Long hostId) {
        this.populateCache();
        HostEntity hostEntity = this.hostDAO.findById(hostId);
        if (hostEntity != null && this.hostConfigMappingByHost.containsKey(hostEntity.getHostId())) {
            TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostConfigMappingEntity.findByHostId", HostConfigMappingEntity.class);
            query.setParameter("hostId", (Object)hostId);
            List hostConfigMappingEntities = this.daoUtils.selectList(query, new Object[0]);
            for (HostConfigMappingEntity entity : hostConfigMappingEntities) {
                ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
            }
            this.hostConfigMappingByHost.remove(hostEntity.getHostId());
        }
    }

    @Transactional
    public void removeByClusterAndHostName(final long clusterId, String hostName) {
        this.populateCache();
        HostEntity hostEntity = this.hostDAO.findByName(hostName);
        if (hostEntity != null && this.hostConfigMappingByHost.containsKey(hostEntity.getHostId())) {
            TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT entity FROM HostConfigMappingEntity entity WHERE entity.clusterId = ?1 AND entity.hostId=?2", HostConfigMappingEntity.class);
            List list = this.daoUtils.selectList(query, clusterId, hostEntity.getHostId());
            for (HostConfigMappingEntity entity : list) {
                ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
            }
            Set<HostConfigMapping> set = this.hostConfigMappingByHost.get(hostEntity.getHostId());
            CollectionUtils.filter(set, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((HostConfigMapping)arg0).getClusterId().equals(clusterId);
                }
            });
        }
    }

    public HostConfigMappingEntity buildHostConfigMappingEntity(HostConfigMapping hostConfigMapping) {
        HostEntity hostEntity = this.hostDAO.findById(hostConfigMapping.getHostId());
        HostConfigMappingEntity hostConfigMappingEntity = new HostConfigMappingEntity();
        hostConfigMappingEntity.setClusterId(hostConfigMapping.getClusterId());
        hostConfigMappingEntity.setCreateTimestamp(hostConfigMapping.getCreateTimestamp());
        hostConfigMappingEntity.setHostId(hostEntity.getHostId());
        hostConfigMappingEntity.setSelected(hostConfigMapping.getSelected());
        hostConfigMappingEntity.setServiceName(hostConfigMapping.getServiceName());
        hostConfigMappingEntity.setType(hostConfigMapping.getType());
        hostConfigMappingEntity.setUser(hostConfigMapping.getUser());
        hostConfigMappingEntity.setVersion(hostConfigMapping.getVersion());
        return hostConfigMappingEntity;
    }

    public HostConfigMapping buildHostConfigMapping(HostConfigMappingEntity hostConfigMappingEntity) {
        HostConfigMappingImpl hostConfigMapping = new HostConfigMappingImpl();
        hostConfigMapping.setClusterId(hostConfigMappingEntity.getClusterId());
        hostConfigMapping.setCreateTimestamp(hostConfigMappingEntity.getCreateTimestamp());
        hostConfigMapping.setHostId(hostConfigMappingEntity.getHostId());
        hostConfigMapping.setServiceName(hostConfigMappingEntity.getServiceName());
        hostConfigMapping.setType(hostConfigMappingEntity.getType());
        hostConfigMapping.setUser(hostConfigMappingEntity.getUser());
        hostConfigMapping.setSelected(hostConfigMappingEntity.isSelected());
        hostConfigMapping.setVersion(hostConfigMappingEntity.getVersion());
        return hostConfigMapping;
    }
}

