/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class HostComponentStateDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;
    @Inject
    HostDAO hostDAO;

    @RequiresSession
    public HostComponentStateEntity findById(long id) {
        return (HostComponentStateEntity)((EntityManager)this.entityManagerProvider.get()).find(HostComponentStateEntity.class, (Object)id);
    }

    @RequiresSession
    public List<HostComponentStateEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findAll", HostComponentStateEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public List<HostComponentStateEntity> findByHost(String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByHost", HostComponentStateEntity.class);
        query.setParameter("hostName", (Object)hostName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostComponentStateEntity> findByService(String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByService", HostComponentStateEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostComponentStateEntity> findByServiceAndComponent(String serviceName, String componentName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByServiceAndComponent", HostComponentStateEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public HostComponentStateEntity findByServiceComponentAndHost(String serviceName, String componentName, String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByServiceComponentAndHost", HostComponentStateEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("hostName", (Object)hostName);
        return (HostComponentStateEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public HostComponentStateEntity findByIndex(Long clusterId, String serviceName, String componentName, Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByIndex", HostComponentStateEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("hostId", (Object)hostId);
        return (HostComponentStateEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public void refresh(HostComponentStateEntity hostComponentStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)hostComponentStateEntity);
    }

    @Transactional
    public void create(HostComponentStateEntity hostComponentStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)hostComponentStateEntity);
    }

    @Transactional
    public HostComponentStateEntity merge(HostComponentStateEntity hostComponentStateEntity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        hostComponentStateEntity = (HostComponentStateEntity)entityManager.merge((Object)hostComponentStateEntity);
        return hostComponentStateEntity;
    }

    @Transactional
    public void remove(HostComponentStateEntity hostComponentStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)hostComponentStateEntity);
    }

    @RequiresSession
    public List<HostComponentStateEntity> findByServiceAndComponentAndNotVersion(String serviceName, String componentName, String version) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentStateEntity.findByServiceAndComponentAndNotVersion", HostComponentStateEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("version", (Object)version);
        return this.daoUtils.selectList(query, new Object[0]);
    }
}

