/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Singleton
public class HostComponentDesiredStateDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    HostDAO hostDAO;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public HostComponentDesiredStateEntity findById(long id) {
        return (HostComponentDesiredStateEntity)((EntityManager)this.entityManagerProvider.get()).find(HostComponentDesiredStateEntity.class, (Object)id);
    }

    @RequiresSession
    public List<HostComponentDesiredStateEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentDesiredStateEntity.findAll", HostComponentDesiredStateEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public HostComponentDesiredStateEntity findByServiceComponentAndHost(String serviceName, String componentName, String hostName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentDesiredStateEntity.findByServiceComponentAndHost", HostComponentDesiredStateEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("hostName", (Object)hostName);
        return (HostComponentDesiredStateEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public HostComponentDesiredStateEntity findByIndex(Long clusterId, String serviceName, String componentName, Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentDesiredStateEntity.findByIndexAndHost", HostComponentDesiredStateEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("hostId", (Object)hostId);
        return (HostComponentDesiredStateEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<HostComponentDesiredStateEntity> findByIndex(Long clusterId, String serviceName, String componentName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("HostComponentDesiredStateEntity.findByIndex", HostComponentDesiredStateEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<HostComponentDesiredStateEntity> findByHostsAndCluster(Collection<Long> hostIds, Long clusterId) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery query = entityManager.createNamedQuery("HostComponentDesiredStateEntity.findByHostsAndCluster", HostComponentDesiredStateEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(hostIds, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            query.setParameter("hostIds", (Object)chunk);
            query.setParameter("clusterId", (Object)clusterId);
            result.addAll(this.daoUtils.selectList(query, new Object[0]));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @Transactional
    public void refresh(HostComponentDesiredStateEntity hostComponentDesiredStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)hostComponentDesiredStateEntity);
    }

    @Transactional
    public void create(HostComponentDesiredStateEntity hostComponentDesiredStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)hostComponentDesiredStateEntity);
    }

    @Transactional
    public HostComponentDesiredStateEntity merge(HostComponentDesiredStateEntity hostComponentDesiredStateEntity) {
        return (HostComponentDesiredStateEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)hostComponentDesiredStateEntity);
    }

    @Transactional
    public void remove(HostComponentDesiredStateEntity hostComponentDesiredStateEntity) {
        HostEntity hostEntity = hostComponentDesiredStateEntity.getHostEntity();
        if (hostEntity == null) {
            throw new IllegalStateException(String.format("Missing hostEntity for host id %1d", hostComponentDesiredStateEntity.getHostId()));
        }
        hostEntity.removeHostComponentDesiredStateEntity(hostComponentDesiredStateEntity);
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)hostComponentDesiredStateEntity);
        this.hostDAO.merge(hostEntity);
    }

    @Transactional
    public void removeId(long id) {
        this.remove(this.findById(id));
    }
}

