/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.helpers.SQLOperations;
import id.onyx.obdp.server.security.authorization.GroupType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class GroupDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public GroupEntity findByPK(Integer groupPK) {
        return (GroupEntity)((EntityManager)this.entityManagerProvider.get()).find(GroupEntity.class, (Object)groupPK);
    }

    @RequiresSession
    public List<GroupEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT group_entity FROM GroupEntity group_entity", GroupEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public GroupEntity findGroupByName(String groupName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("groupByName", GroupEntity.class);
        query.setParameter("groupname", (Object)groupName.toLowerCase());
        try {
            return (GroupEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @RequiresSession
    public GroupEntity findGroupByNameAndType(String groupName, GroupType groupType) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT group_entity FROM GroupEntity group_entity WHERE group_entity.groupType=:type AND lower(group_entity.groupName)=lower(:name)", GroupEntity.class);
        query.setParameter("type", (Object)groupType);
        query.setParameter("name", (Object)groupName);
        try {
            return (GroupEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @RequiresSession
    public List<GroupEntity> findGroupsByPrincipal(List<PrincipalEntity> principalList) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT grp FROM GroupEntity grp WHERE grp.principal IN :principalList", GroupEntity.class);
        ArrayList result = new ArrayList();
        SQLOperations.batch(principalList, 999, (chunk, currentBatch, totalBatches, totalSize) -> {
            query.setParameter("principalList", (Object)chunk);
            result.addAll(this.daoUtils.selectList(query, new Object[0]));
            return 0;
        });
        return Lists.newArrayList(result);
    }

    @RequiresSession
    public GroupEntity findGroupByPrincipal(PrincipalEntity principal) {
        if (principal == null) {
            return null;
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT group_entity FROM GroupEntity group_entity WHERE group_entity.principal.id=:principalId", GroupEntity.class);
        query.setParameter("principalId", (Object)principal.getId());
        return (GroupEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @Transactional
    public void create(GroupEntity group) {
        this.create(new HashSet<GroupEntity>(Arrays.asList(group)));
    }

    @Transactional
    public void create(Set<GroupEntity> groups) {
        for (GroupEntity group : groups) {
            group.setGroupName(group.getGroupName().toLowerCase());
            ((EntityManager)this.entityManagerProvider.get()).persist((Object)group);
        }
    }

    @Transactional
    public GroupEntity merge(GroupEntity group) {
        group.setGroupName(group.getGroupName().toLowerCase());
        return (GroupEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)group);
    }

    @Transactional
    public void merge(Set<GroupEntity> groups) {
        for (GroupEntity group : groups) {
            group.setGroupName(group.getGroupName().toLowerCase());
            ((EntityManager)this.entityManagerProvider.get()).merge((Object)group);
        }
    }

    @Transactional
    public void remove(GroupEntity group) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(group));
        ((EntityManager)this.entityManagerProvider.get()).getEntityManagerFactory().getCache().evictAll();
    }

    @Transactional
    public void remove(Set<GroupEntity> groups) {
        for (GroupEntity groupEntity : groups) {
            ((EntityManager)this.entityManagerProvider.get()).remove(((EntityManager)this.entityManagerProvider.get()).merge((Object)groupEntity));
        }
    }

    @Transactional
    public void removeByPK(Integer groupPK) {
        this.remove(this.findByPK(groupPK));
    }
}

