/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ExtensionLinkRequest;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ExtensionLinkEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class ExtensionLinkDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public List<ExtensionLinkEntity> find(ExtensionLinkRequest request) {
        if (request.getLinkId() != null) {
            ExtensionLinkEntity entity = this.findById(Long.parseLong(request.getLinkId()));
            ArrayList<ExtensionLinkEntity> list = new ArrayList<ExtensionLinkEntity>();
            list.add(entity);
            return list;
        }
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String extensionName = request.getExtensionName();
        String extensionVersion = request.getExtensionVersion();
        if (stackName != null && stackVersion != null) {
            if (extensionName != null) {
                if (extensionVersion != null) {
                    ExtensionLinkEntity entity = this.findByStackAndExtension(stackName, stackVersion, extensionName, extensionVersion);
                    ArrayList<ExtensionLinkEntity> list = new ArrayList<ExtensionLinkEntity>();
                    list.add(entity);
                    return list;
                }
                return this.findByStackAndExtensionName(stackName, stackVersion, extensionName);
            }
            return this.findByStack(stackName, stackVersion);
        }
        if (extensionName != null && extensionVersion != null) {
            return this.findByExtension(extensionName, extensionVersion);
        }
        return this.findAll();
    }

    @RequiresSession
    public ExtensionLinkEntity findById(long linkId) {
        return (ExtensionLinkEntity)((EntityManager)this.entityManagerProvider.get()).find(ExtensionLinkEntity.class, (Object)linkId);
    }

    @RequiresSession
    public List<ExtensionLinkEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionLinkEntity.findAll", ExtensionLinkEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ExtensionLinkEntity> findByExtension(String extensionName, String extensionVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionLinkEntity.findByExtension", ExtensionLinkEntity.class);
        query.setParameter("extensionName", (Object)extensionName);
        query.setParameter("extensionVersion", (Object)extensionVersion);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ExtensionLinkEntity> findByStack(String stackName, String stackVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionLinkEntity.findByStack", ExtensionLinkEntity.class);
        query.setParameter("stackName", (Object)stackName);
        query.setParameter("stackVersion", (Object)stackVersion);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ExtensionLinkEntity> findByStackAndExtensionName(String stackName, String stackVersion, String extensionName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionLinkEntity.findByStackAndExtensionName", ExtensionLinkEntity.class);
        query.setParameter("stackName", (Object)stackName);
        query.setParameter("stackVersion", (Object)stackVersion);
        query.setParameter("extensionName", (Object)extensionName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ExtensionLinkEntity findByStackAndExtension(String stackName, String stackVersion, String extensionName, String extensionVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionLinkEntity.findByStackAndExtension", ExtensionLinkEntity.class);
        query.setParameter("stackName", (Object)stackName);
        query.setParameter("stackVersion", (Object)stackVersion);
        query.setParameter("extensionName", (Object)extensionName);
        query.setParameter("extensionVersion", (Object)extensionVersion);
        return (ExtensionLinkEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void create(ExtensionLinkEntity link) throws OBDPException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)link);
    }

    @Transactional
    public void refresh(ExtensionLinkEntity link) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)link);
    }

    @Transactional
    public ExtensionLinkEntity merge(ExtensionLinkEntity link) {
        return (ExtensionLinkEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)link);
    }

    public void createOrUpdate(ExtensionLinkEntity link) throws OBDPException {
        if (null == link.getLinkId()) {
            this.create(link);
        } else {
            this.merge(link);
        }
    }

    @Transactional
    public void remove(ExtensionLinkEntity link) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        if (null != (link = this.findById(link.getLinkId()))) {
            entityManager.remove((Object)link);
        }
    }
}

