/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ExtensionDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public ExtensionEntity findById(long extensionId) {
        return (ExtensionEntity)((EntityManager)this.entityManagerProvider.get()).find(ExtensionEntity.class, (Object)extensionId);
    }

    @RequiresSession
    public List<ExtensionEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionEntity.findAll", ExtensionEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ExtensionEntity find(String extensionName, String extensionVersion) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ExtensionEntity.findByNameAndVersion", ExtensionEntity.class);
        query.setParameter("extensionName", (Object)extensionName);
        query.setParameter("extensionVersion", (Object)extensionVersion);
        return (ExtensionEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void create(ExtensionEntity extension) throws OBDPException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)extension);
    }

    @Transactional
    public void refresh(ExtensionEntity extension) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)extension);
    }

    @Transactional
    public ExtensionEntity merge(ExtensionEntity extension) {
        return (ExtensionEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)extension);
    }

    public void createOrUpdate(ExtensionEntity extension) throws OBDPException {
        if (null == extension.getExtensionId()) {
            this.create(extension);
        } else {
            this.merge(extension);
        }
    }

    @Transactional
    public void remove(ExtensionEntity extension) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        if (null != (extension = this.findById(extension.getExtensionId()))) {
            entityManager.remove((Object)extension);
        }
    }
}

