/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collections;
import java.util.List;

@Singleton
public class DaoUtils {
    public <T> List<T> selectAll(EntityManager entityManager, Class<T> entityClass) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(entityClass);
        Root root = query.from(entityClass);
        query.select((Selection)root);
        TypedQuery typedQuery = entityManager.createQuery(query);
        try {
            return typedQuery.getResultList();
        }
        catch (NoResultException ignored) {
            return Collections.emptyList();
        }
    }

    public <T> List<T> selectList(TypedQuery<T> query, Object ... parameters) {
        this.setParameters((Query)query, parameters);
        try {
            return query.getResultList();
        }
        catch (NoResultException ignored) {
            return Collections.emptyList();
        }
    }

    public <T> T selectSingle(TypedQuery<T> query, Object ... parameters) {
        this.setParameters((Query)query, parameters);
        try {
            return (T)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    public <T> T selectOne(TypedQuery<T> query, Object ... parameters) {
        this.setParameters((Query)query, parameters);
        try {
            return (T)query.setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    public int executeUpdate(Query query, Object ... parameters) {
        this.setParameters(query, parameters);
        return query.executeUpdate();
    }

    public void setParameters(Query query, Object ... parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i + 1, parameters[i]);
        }
    }
}

