/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;

public class CrudDAO<E, K> {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;
    private Class<E> entityClass;

    public CrudDAO(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    @RequiresSession
    public E findByPK(K pk) {
        return (E)((EntityManager)this.entityManagerProvider.get()).find(this.entityClass, pk);
    }

    @RequiresSession
    public List<E> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT entity FROM " + this.entityClass.getSimpleName() + " entity", this.entityClass);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public Long findMaxId(String idColName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT MAX(entity." + idColName + ") FROM " + this.entityClass.getSimpleName() + " entity", Long.class);
        Long result = (Long)this.daoUtils.selectOne(query, new Object[0]);
        return result == null ? 0L : result;
    }

    @Transactional
    protected void create(E entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist(entity);
    }

    @Transactional
    public E merge(E entity) {
        return (E)((EntityManager)this.entityManagerProvider.get()).merge(entity);
    }

    @Transactional
    public void refresh(E entity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh(entity);
    }

    @Transactional
    public void remove(E entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove(this.merge(entity));
        ((EntityManager)this.entityManagerProvider.get()).getEntityManagerFactory().getCache().evictAll();
    }

    @Transactional
    public void remove(Collection<E> entities) {
        for (E entity : entities) {
            ((EntityManager)this.entityManagerProvider.get()).remove(this.merge(entity));
        }
        ((EntityManager)this.entityManagerProvider.get()).getEntityManagerFactory().getCache().evictAll();
    }

    @Transactional
    public void removeByPK(K pk) {
        this.remove(this.findByPK(pk));
    }
}

