/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.cache.ConfigGroupHostMapping;
import id.onyx.obdp.server.orm.cache.ConfigGroupHostMappingImpl;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupHostMappingEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupHostMappingEntityPK;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.cluster.ClusterFactory;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.configgroup.ConfigGroupFactory;
import id.onyx.obdp.server.state.host.HostFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

@Singleton
public class ConfigGroupHostMappingDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;
    @Inject
    private ConfigGroupFactory configGroupFactory;
    @Inject
    private ClusterFactory clusterFactory;
    @Inject
    private HostFactory hostFactory;
    @Inject
    Clusters clusters;
    private final ReadWriteLock gl = new ReentrantReadWriteLock();
    private Map<Long, Set<ConfigGroupHostMapping>> configGroupHostMappingByHost;
    private volatile boolean cacheLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCache() {
        if (!this.cacheLoaded) {
            this.gl.writeLock().lock();
            try {
                if (!this.cacheLoaded) {
                    if (this.configGroupHostMappingByHost == null) {
                        this.configGroupHostMappingByHost = new HashMap<Long, Set<ConfigGroupHostMapping>>();
                        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT entity FROM ConfigGroupHostMappingEntity entity", ConfigGroupHostMappingEntity.class);
                        List configGroupHostMappingEntities = this.daoUtils.selectList(query, new Object[0]);
                        for (ConfigGroupHostMappingEntity configGroupHostMappingEntity : configGroupHostMappingEntities) {
                            Set<ConfigGroupHostMapping> setByHost = this.configGroupHostMappingByHost.get(configGroupHostMappingEntity.getHostId());
                            if (setByHost == null) {
                                setByHost = new HashSet<ConfigGroupHostMapping>();
                                this.configGroupHostMappingByHost.put(configGroupHostMappingEntity.getHostId(), setByHost);
                            }
                            ConfigGroupHostMapping configGroupHostMapping = this.buildConfigGroupHostMapping(configGroupHostMappingEntity);
                            setByHost.add(configGroupHostMapping);
                        }
                    }
                    this.cacheLoaded = true;
                }
            }
            finally {
                this.gl.writeLock().unlock();
            }
        }
    }

    @RequiresSession
    public ConfigGroupHostMappingEntity findByPK(ConfigGroupHostMappingEntityPK configGroupHostMappingEntityPK) {
        return (ConfigGroupHostMappingEntity)((EntityManager)this.entityManagerProvider.get()).find(ConfigGroupHostMappingEntity.class, (Object)configGroupHostMappingEntityPK);
    }

    @RequiresSession
    public Set<ConfigGroupHostMapping> findByHostId(Long hostId) {
        this.populateCache();
        if (!this.configGroupHostMappingByHost.containsKey(hostId)) {
            return null;
        }
        HashSet<ConfigGroupHostMapping> set = new HashSet<ConfigGroupHostMapping>((Collection)this.configGroupHostMappingByHost.get(hostId));
        return set;
    }

    @RequiresSession
    public Set<ConfigGroupHostMapping> findByGroup(final Long groupId) {
        this.populateCache();
        HashSet<ConfigGroupHostMapping> result = new HashSet<ConfigGroupHostMapping>();
        for (Set<ConfigGroupHostMapping> item : this.configGroupHostMappingByHost.values()) {
            HashSet<ConfigGroupHostMapping> setByHost = new HashSet<ConfigGroupHostMapping>(item);
            CollectionUtils.filter(setByHost, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return ((ConfigGroupHostMapping)arg0).getConfigGroupId().equals(groupId);
                }
            });
            result.addAll(setByHost);
        }
        return result;
    }

    @RequiresSession
    public List<ConfigGroupHostMappingEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), ConfigGroupHostMappingEntity.class);
    }

    @Transactional
    public void create(ConfigGroupHostMappingEntity configGroupHostMappingEntity) {
        this.populateCache();
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)configGroupHostMappingEntity);
        Set<ConfigGroupHostMapping> set = this.configGroupHostMappingByHost.get(configGroupHostMappingEntity.getHostId());
        if (set == null) {
            set = new HashSet<ConfigGroupHostMapping>();
            this.configGroupHostMappingByHost.put(configGroupHostMappingEntity.getHostId(), set);
        }
        set.add(this.buildConfigGroupHostMapping(configGroupHostMappingEntity));
    }

    @Transactional
    public ConfigGroupHostMappingEntity merge(ConfigGroupHostMappingEntity configGroupHostMappingEntity) {
        this.populateCache();
        Set<ConfigGroupHostMapping> set = this.configGroupHostMappingByHost.get(configGroupHostMappingEntity.getHostId());
        if (set == null) {
            set = new HashSet<ConfigGroupHostMapping>();
            this.configGroupHostMappingByHost.put(configGroupHostMappingEntity.getHostId(), set);
        }
        set.remove(this.buildConfigGroupHostMapping(configGroupHostMappingEntity));
        set.add(this.buildConfigGroupHostMapping(configGroupHostMappingEntity));
        return (ConfigGroupHostMappingEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)configGroupHostMappingEntity);
    }

    @Transactional
    public void refresh(ConfigGroupHostMappingEntity configGroupHostMappingEntity) {
        this.cacheLoaded = false;
        this.populateCache();
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)configGroupHostMappingEntity);
    }

    @Transactional
    public void remove(final ConfigGroupHostMappingEntity configGroupHostMappingEntity) {
        this.populateCache();
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(configGroupHostMappingEntity));
        Set<ConfigGroupHostMapping> setByHost = this.configGroupHostMappingByHost.get(configGroupHostMappingEntity.getHostId());
        if (setByHost != null) {
            CollectionUtils.filter(setByHost, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((ConfigGroupHostMapping)arg0).getConfigGroupId().equals(configGroupHostMappingEntity.getConfigGroupId());
                }
            });
        }
    }

    @Transactional
    public void removeByPK(final ConfigGroupHostMappingEntityPK configGroupHostMappingEntityPK) {
        this.populateCache();
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByPK(configGroupHostMappingEntityPK));
        Set<ConfigGroupHostMapping> setByHost = this.configGroupHostMappingByHost.get(configGroupHostMappingEntityPK.getHostId());
        if (setByHost != null) {
            CollectionUtils.filter(setByHost, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((ConfigGroupHostMapping)arg0).getConfigGroupId().equals(configGroupHostMappingEntityPK.getConfigGroupId());
                }
            });
        }
    }

    @Transactional
    public void removeAllByGroup(final Long groupId) {
        this.populateCache();
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("DELETE FROM ConfigGroupHostMappingEntity confighosts WHERE confighosts.configGroupId = ?1", Long.class);
        this.daoUtils.executeUpdate((Query)query, groupId);
        ((EntityManager)this.entityManagerProvider.get()).flush();
        for (Set<ConfigGroupHostMapping> setByHost : this.configGroupHostMappingByHost.values()) {
            CollectionUtils.filter(setByHost, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((ConfigGroupHostMapping)arg0).getConfigGroupId().equals(groupId);
                }
            });
        }
    }

    @Transactional
    public void removeAllByHost(Long hostId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("DELETE FROM ConfigGroupHostMappingEntity confighosts WHERE confighosts.hostId = ?1", String.class);
        this.daoUtils.executeUpdate((Query)query, hostId);
        Set<ConfigGroupHostMapping> setByHost = this.configGroupHostMappingByHost.get(hostId);
        setByHost.clear();
    }

    private ConfigGroupHostMapping buildConfigGroupHostMapping(ConfigGroupHostMappingEntity configGroupHostMappingEntity) {
        ConfigGroupHostMappingImpl configGroupHostMapping = new ConfigGroupHostMappingImpl();
        configGroupHostMapping.setConfigGroup(this.buildConfigGroup(configGroupHostMappingEntity.getConfigGroupEntity()));
        configGroupHostMapping.setConfigGroupId(configGroupHostMappingEntity.getConfigGroupId());
        configGroupHostMapping.setHost(this.buildHost(configGroupHostMappingEntity.getHostEntity()));
        configGroupHostMapping.setHostId(configGroupHostMappingEntity.getHostId());
        return configGroupHostMapping;
    }

    private ConfigGroup buildConfigGroup(ConfigGroupEntity configGroupEntity) {
        Cluster cluster = null;
        try {
            cluster = this.clusters.getClusterById(configGroupEntity.getClusterId());
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        ConfigGroup configGroup = this.configGroupFactory.createExisting(cluster, configGroupEntity);
        return configGroup;
    }

    private Host buildHost(HostEntity hostEntity) {
        Host host = this.hostFactory.create(hostEntity);
        return host;
    }
}

